/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PIXAdvancedFWDialog.cc,v 1.6 2003/11/09 05:57:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "PIXAdvancedFWDialog.hh"
#include "MessageDialog.hh"

#include "fwbuilder/Resources.hh"
#include "fwbuilder/Interface.hh"

#include <gtk--.h>
#include <iostream>
#include <sstream>

using namespace std;
using namespace libfwbuilder;



PIXAdvancedFWDialog::PIXAdvancedFWDialog(Firewall *_fo)
{ 
    fwobj=_fo;

    allFixups.push_back(fixupControl( pix_ctiqbe_switch,   pix_ctiqbe_port,       NULL,               NULL,             "ctiqbe_fixup"    , "ctiqbe"    , 0));
    allFixups.push_back(fixupControl( pix_dns_switch,      pix_dns_max_length,    NULL,               NULL,             "dns_fixup"       , "dns"       , 1));
    allFixups.push_back(fixupControl( pix_espike_switch,   NULL,                  NULL,               NULL,             "espike_fixup"    , "esp-ike"   , 2));
    allFixups.push_back(fixupControl( pix_ftp_switch,      pix_ftp_port,          NULL,               pix_ftp_strict,   "ftp_fixup"       , "ftp"       , 3));
    allFixups.push_back(fixupControl( pix_h323h225_switch, pix_h323h225_port1,    pix_h323h225_port2, NULL,             "h323_h225_fixup" , "h323 h225" , 4));
    allFixups.push_back(fixupControl( pix_h323ras_switch,  pix_h323ras_port1,     pix_h323ras_port2,  NULL,             "h323_ras_fixup"  , "h323 ras"  , 5));
    allFixups.push_back(fixupControl( pix_http_switch,     pix_http_port1,        pix_http_port2,     NULL,             "http_fixup"      , "http"      , 6));
    allFixups.push_back(fixupControl( pix_icmperror_switch, NULL,                 NULL,               NULL,             "icmp_error_fixup", "icmp error", 7));
    allFixups.push_back(fixupControl( pix_ils_switch,      pix_ils_port1,         pix_ils_port2,      NULL,             "ils_fixup"       , "ils"       , 8));
    allFixups.push_back(fixupControl( pix_mgcp_switch,     pix_mgcp_gateway_port, pix_mgcp_call_agent_port, NULL,       "mgcp_fixup"      , "mgcp"      , 9));
    allFixups.push_back(fixupControl( pix_pptp_switch,     pix_pptp_port,         NULL,               NULL,             "pptp_fixup"      , "pptp"      , 10));
    allFixups.push_back(fixupControl( pix_rsh_switch,      pix_rsh_port1,         NULL,               NULL,             "rsh_fixup"       , "rsh"       , 11));
    allFixups.push_back(fixupControl( pix_rtsp_switch,     pix_rtsp_port,         NULL,               NULL,             "rtsp_fixup"      , "rtsp"      , 12));
    allFixups.push_back(fixupControl( pix_sip_switch,      pix_sip_port1,         pix_sip_port2,      NULL,             "sip_fixup"       , "sip"       , 13));
    allFixups.push_back(fixupControl( pix_sipudp_switch,   pix_sip_udp_port1,     NULL,               NULL,             "sip_udp_fixup"   , "sip udp"   , 14));
    allFixups.push_back(fixupControl( pix_skinny_switch,   pix_skinny_port1,      pix_skinny_port2,   NULL,             "skinny_fixup"    , "skinny"    , 15));
    allFixups.push_back(fixupControl( pix_smtp_switch,     pix_smtp_port1,        pix_smtp_port2,     NULL,             "smtp_fixup"      , "smtp"      , 16));
    allFixups.push_back(fixupControl( pix_sqlnet_switch,   pix_sqlnet_port1,      pix_sqlnet_port2,   NULL,             "sqlnet_fixup"    , "sqlnet"    , 17));
    allFixups.push_back(fixupControl( pix_tftp_switch,     pix_tftp_port,         NULL,               NULL,             "tftp_fixup"      , "tftp"      , 18));


    ((Gtk::Label*)(fragguard->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(fragguard->get_child()))->set_justify(GTK_JUSTIFY_LEFT);
    ((Gtk::Label*)(connection_timewait->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(route_dnat->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(route_dnat->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(nodnsalias_inbound->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(nodnsalias_outbound->get_child()))->set_alignment(0.0,1.0);

    ok_button->grab_focus();

    log_facilities[""    ]="      "  ;
    log_facilities["16"  ]="LOCAL0"  ;
    log_facilities["17"  ]="LOCAL1"  ;
    log_facilities["18"  ]="LOCAL2"  ;
    log_facilities["19"  ]="LOCAL3"  ;
    log_facilities["20"  ]="LOCAL4"  ;
    log_facilities["21"  ]="LOCAL5"  ;
    log_facilities["22"  ]="LOCAL6"  ;
    log_facilities["23"  ]="LOCAL7"  ;

    log_levels["" ]="        "  ;
    log_levels["0"]="0 - System Unusable                  ";
    log_levels["1"]="1 - Take Immediate Action            ";
    log_levels["2"]="2 - Critical Condition               ";
    log_levels["3"]="3 - Error Message                    ";
    log_levels["4"]="4 - Warning Message                  ";
    log_levels["5"]="5 - Normal but significant condition ";
    log_levels["6"]="6 - Informational                    ";
    log_levels["7"]="7 - Debug Message                    ";


		
		
    syslog_facility->set_menu(log_facilities);
    syslog_facility->show_all();
    
    logging_trap_level->set_menu(log_levels);
    logging_trap_level->show_all();

    logging_buffered_level->set_menu(log_levels);
    logging_buffered_level->show_all();

    logging_console_level->set_menu(log_levels);
    logging_console_level->show_all();


    FWOptions *options=fwobj->getOptionsObject();
    assert(options!=NULL);

    string vers="version_"+fwobj->getStr("version");


    map<string,string> fixup_switch_menu;

/* choice of the values for enable/disable/skip is historical */
    fixup_switch_menu["0"]="Enable";
    fixup_switch_menu["1"]="Disable";
    fixup_switch_menu["2"]="Skip";

    for (list<fixupControl>::iterator fi=allFixups.begin(); fi!=allFixups.end(); fi++)
    {
        fi->switch_widget->set_menu(fixup_switch_menu);
        fi->switch_widget->changed.connect( SigC::slot(this,&PIXAdvancedFWDialog::on_fixup_cmd_changed));
        fi->switch_widget->show_all();
    }


    
    string lst=Resources::platform_res["pix"]->getResourceStr(
            "/FWBuilderResources/Target/options/"+vers+"/fixups/list");

    for (list<fixupControl>::iterator fi=allFixups.begin(); fi!=allFixups.end(); fi++)
    {
        string::size_type i,j, k;
        i=0;
        bool present=false;
        while ( i<lst.size() )
        {
            j=lst.find(",",i);
            if (lst.substr(i,j-i)==fi->fwoption) { present=true; break; }
            if (j==string::npos) break;
            i=j+1;
        }
        if (!present)
        {
            fi->active=false;
            fixup_notebook->get_nth_page( fi->page )->hide();
        }
    }

//    new_fixup_type->set_popdown_strings( fixup_names );

}

void PIXAdvancedFWDialog::loadFixups()
{
    FWOptions *options=fwobj->getOptionsObject();
    assert(options!=NULL);

    for (list<fixupControl>::iterator fi=allFixups.begin(); fi!=allFixups.end(); fi++)
    {
        if (!fi->active) continue;
        string f=options->getStr(fi->fwoption);
        if (!f.empty())
        {
// "0" means "fixup" or "enable" in a pop-down menu (historical)
// "1" means "no fixup" or "disable" in a pop-down menu (historical)
            int    sw;

            int    p1,p2;   // two port numbers
            string arg3n;   // option name
            bool   arg3v;   // option state (on/off)

            istringstream str(f);

            str >> sw >> p1 >> p2 >> arg3n >> arg3v;

            if (arg3n=="nil")    arg3n="";

            switch (sw)
            {
            case 0: fi->switch_widget->set_active_item_by_label("Enable");  break;
            case 1: fi->switch_widget->set_active_item_by_label("Disable"); break;
            case 2: fi->switch_widget->set_active_item_by_label("Skip");    break;
            }
/* if values are 0 in the data file, we stick with defaults. Defaults are preconfigured
 * in the GUI (via appropriate settings in pix.glade file */
            if (fi->arg1 && p1!=0) fi->arg1->set_value(p1);
            if (fi->arg2 && p2!=0) fi->arg2->set_value(p2);
            if (fi->arg3) fi->arg3->set_active(arg3v);

        } else {
            fi->switch_widget->set_active_item_by_label("Skip");
        }
    }
}

void PIXAdvancedFWDialog::saveFixups()
{
    FWOptions *options=fwobj->getOptionsObject();
    assert(options!=NULL);

    for (list<fixupControl>::iterator fi=allFixups.begin(); fi!=allFixups.end(); fi++)
    {
        string name=fi->fwoption;
        string sw  =fi->switch_widget->get_value();
        int    p1  =(fi->arg1)?fi->arg1->get_value_as_int():0;
        int    p2  =(fi->arg2)?fi->arg2->get_value_as_int():0;
        string on  =(name=="ftp_fixup")?"strict":"nil";
        bool   ov  =(fi->arg3)?fi->arg3->get_active():false;

        if (!fi->active) sw="2";

        ostringstream str;
        str << sw << " " << p1 << " " << p2 << " " << on << " " << ov;

        options->setStr( fi->fwoption , str.str() );
    }
}



void  PIXAdvancedFWDialog::wrk2dlg()
{
    FWOptions *options=fwobj->getOptionsObject();
    assert(options!=NULL);
    string vers="version_"+fwobj->getStr("version");

    syslog_host->set_text(        options->getStr("pix_syslog_host"        ) );
    syslog_queue_size->set_value( options->getInt( "pix_syslog_queue_size" ) );
    syslog_facility->set_active_item_by_value( options->getStr("pix_syslog_facility") );
    logging_trap_level->set_active_item_by_value( options->getStr("pix_logging_trap_level") );

    logging_buffered->set_active( options->getBool("pix_logging_buffered") );
    logging_buffered_level->set_active_item_by_value( options->getStr("pix_logging_buffered_level") );

    logging_console->set_active( options->getBool("pix_logging_console") );
    logging_console_level->set_active_item_by_value( options->getStr("pix_logging_console_level") );

    logging_timestamp->set_active( options->getBool("pix_logging_timestamp") );

    emblem_log_format->set_sensitive( Resources::platform_res["pix"]->getResourceBool(
               "/FWBuilderResources/Target/options/"+vers+"/pix_emblem_log_format") );

    emblem_log_format->set_active( options->getBool("pix_emblem_log_format") );

    vector<string> interfaces;
    list<FWObject*> l2=fwobj->getByType(Interface::TYPENAME);
    for (list<FWObject*>::iterator i=l2.begin(); i!=l2.end(); ++i) 
        interfaces.push_back( (Interface::cast(*i))->getLabel() );

    syslog_device_id_interface_val->set_menu(interfaces);

    if (Resources::platform_res["pix"]->getResourceBool(
            "/FWBuilderResources/Target/options/"+vers+"/pix_syslog_device_id_supported") )
    {
        syslog_device_id_hostname->set_sensitive(true);
        syslog_device_id_interface->set_sensitive(true);
        syslog_device_id_interface_val->set_sensitive(true);
        syslog_device_id_string->set_sensitive(true);
        syslog_device_id_string_val->set_sensitive(true);

        string s=options->getStr("pix_syslog_device_id_opt");
        string v=options->getStr("pix_syslog_device_id_val");
        if (s=="hostname")  syslog_device_id_hostname->set_active(true);
        if (s=="interface")
        {
            syslog_device_id_interface->set_active(true);
            syslog_device_id_interface_val->set_active_item_by_value(v);
        }
        if (s=="string")
        {
            syslog_device_id_string->set_active(true);
            syslog_device_id_string_val->set_text(v);
        }
    } else
    {
        syslog_device_id_hostname->set_sensitive(false);
        syslog_device_id_interface->set_sensitive(false);
        syslog_device_id_interface_val->set_sensitive(false);
        syslog_device_id_string->set_sensitive(false);
        syslog_device_id_string_val->set_sensitive(false);
    }

    if (Resources::platform_res["pix"]->getResourceBool(
            "/FWBuilderResources/Target/options/"+vers+"/pix_security_fragguard_supported") )
    {
        fragguard->set_sensitive(true);
        fragguard->set_active(           options->getBool("pix_fragguard"));
    } else
    {
        fragguard->set_sensitive(false);
    }

    if (Resources::platform_res["pix"]->getResourceBool(
            "/FWBuilderResources/Target/options/"+vers+"/pix_route_dnat_supported") )
    {
        route_dnat->set_sensitive(true);
        route_dnat->set_active(          options->getBool("pix_route_dnat"));
    } else
    {
        route_dnat->set_sensitive(false);
    }
    
    xlate_hh->set_value(          options->getInt("xlate_hh"    ) );
    xlate_mm->set_value(          options->getInt("xlate_mm"    ) );
    xlate_ss->set_value(          options->getInt("xlate_ss"    ) );

    conn_hh->set_value(           options->getInt("conn_hh"     ) );
    conn_mm->set_value(           options->getInt("conn_mm"     ) );
    conn_ss->set_value(           options->getInt("conn_ss"     ) );

    udp_hh->set_value(            options->getInt("udp_hh"        ) );
    udp_mm->set_value(            options->getInt("udp_mm"        ) );
    udp_ss->set_value(            options->getInt("udp_ss"        ) );

    rpc_hh->set_value(            options->getInt("rpc_hh"        ) );
    rpc_mm->set_value(            options->getInt("rpc_mm"        ) );
    rpc_ss->set_value(            options->getInt("rpc_ss"        ) );

    h323_hh->set_value(           options->getInt("h323_hh"      ) );
    h323_mm->set_value(           options->getInt("h323_mm"      ) );
    h323_ss->set_value(           options->getInt("h323_ss"      ) );

    sip_hh->set_value(            options->getInt("sip_hh"        ) );
    sip_mm->set_value(            options->getInt("sip_mm"        ) );
    sip_ss->set_value(            options->getInt("sip_ss"        ) );

    sip_media_hh->set_value(      options->getInt("sip_media_hh"  ) );
    sip_media_mm->set_value(      options->getInt("sip_media_mm"  ) );
    sip_media_ss->set_value(      options->getInt("sip_media_ss"  ) );
                                                                  
    half_closed_hh->set_value(    options->getInt("half-closed_hh") );
    half_closed_mm->set_value(    options->getInt("half-closed_mm") );
    half_closed_ss->set_value(    options->getInt("half-closed_ss") );

    uauth_hh->set_value(         options->getInt("uauth_hh"    ) );
    uauth_mm->set_value(         options->getInt("uauth_mm"    ) );
    uauth_ss->set_value(         options->getInt("uauth_ss"    ) );
    uauth_abs->set_active(       options->getBool("uauth_abs"  ) );
    uauth_inact->set_active(     options->getBool("uauth_inact") );

    telnet_timeout->set_value( options->getInt("pix_telnet_timeout") );
    ssh_timeout->set_value( options->getInt("pix_ssh_timeout") );

    resetinbound->set_active( options->getBool("pix_resetinbound"));
    resetoutside->set_active( options->getBool("pix_resetoutside"));

    connection_timewait->set_active( options->getBool("pix_connection_timewait"));
    floodguard->set_active(          options->getBool("pix_floodguard"));
    nodnsalias_inbound->set_active(  options->getBool("pix_nodnsalias_inbound"));
    nodnsalias_outbound->set_active( options->getBool("pix_nodnsalias_outbound"));

    max_conns->set_value( options->getInt( "pix_max_conns" ) );
    emb_limit->set_value( options->getInt( "pix_emb_limit" ) );

    loadFixups();
    showFixups();
}

void  PIXAdvancedFWDialog::dlg2wrk()
{
    FWOptions *options=fwobj->getOptionsObject();
    assert(options!=NULL);
    string vers="version_"+fwobj->getStr("version");

    options->setStr("pix_syslog_host",       syslog_host->get_text() );
    options->setInt("pix_syslog_queue_size", syslog_queue_size->get_value_as_int() );

    options->setInt("pix_max_conns",         max_conns->get_value_as_int() );
    options->setInt("pix_emb_limit",         emb_limit->get_value_as_int() );

    options->setStr("pix_syslog_facility"  ,  syslog_facility->get_value()    );
    options->setStr("pix_logging_trap_level", logging_trap_level->get_value() );

    options->setBool("pix_logging_buffered",       logging_buffered->get_active()      );
    options->setStr( "pix_logging_buffered_level", logging_buffered_level->get_value() );

    options->setBool("pix_logging_console",       logging_console->get_active()      );
    options->setStr( "pix_logging_console_level", logging_console_level->get_value() );

    options->setBool("pix_logging_timestamp",     logging_timestamp->get_active()    );

    options->setBool("pix_emblem_log_format",     emblem_log_format->get_active()  );


    if (Resources::platform_res["pix"]->getResourceBool(
            "/FWBuilderResources/Target/options/"+vers+"/pix_syslog_device_id_supported") )
    {
        string s,v;
        if (syslog_device_id_hostname->get_active())  s="hostname";
        if (syslog_device_id_interface->get_active())
        {
            s="interface";
            v=syslog_device_id_interface_val->get_value();
        }
        if (syslog_device_id_string->get_active())
        {
            s="string";
            v=syslog_device_id_string_val->get_text();
        }

        options->setStr("pix_syslog_device_id_opt",s);
        options->setStr("pix_syslog_device_id_val",v);
    }

    if (Resources::platform_res["pix"]->getResourceBool(
            "/FWBuilderResources/Target/options/"+vers+"/pix_security_fragguard_supported") )
    {
        options->setBool("pix_fragguard", fragguard->get_active() );
    }

    if (Resources::platform_res["pix"]->getResourceBool(
            "/FWBuilderResources/Target/options/"+vers+"/pix_route_dnat_supported") )
    {
        options->setBool("pix_route_dnat", route_dnat->get_active() );
    }
    

    options->setInt("xlate_hh"         , xlate_hh->get_value_as_int() );
    options->setInt("xlate_mm"         , xlate_mm->get_value_as_int() );
    options->setInt("xlate_ss"         , xlate_ss->get_value_as_int() );
                                             
    options->setInt("conn_hh"          , conn_hh->get_value_as_int() );
    options->setInt("conn_mm"          , conn_mm->get_value_as_int() );
    options->setInt("conn_ss"          , conn_ss->get_value_as_int() );
                                                                     
    options->setInt("udp_hh"           , udp_hh->get_value_as_int() );
    options->setInt("udp_mm"           , udp_mm->get_value_as_int() );
    options->setInt("udp_ss"           , udp_ss->get_value_as_int() );
                                                                    
    options->setInt("rpc_hh"           , rpc_hh->get_value_as_int() );
    options->setInt("rpc_mm"           , rpc_mm->get_value_as_int() );
    options->setInt("rpc_ss"           , rpc_ss->get_value_as_int() );
                                                                     
    options->setInt("h323_hh"          , h323_hh->get_value_as_int() );
    options->setInt("h323_mm"          , h323_mm->get_value_as_int() );
    options->setInt("h323_ss"          , h323_ss->get_value_as_int() );
                                                                     
    options->setInt("sip_hh"           , sip_hh->get_value_as_int() );
    options->setInt("sip_mm"           , sip_mm->get_value_as_int() );
    options->setInt("sip_ss"           , sip_ss->get_value_as_int() );
                                            
    options->setInt("sip_media_hh"     , sip_media_hh->get_value_as_int() );
    options->setInt("sip_media_mm"     , sip_media_mm->get_value_as_int() );
    options->setInt("sip_media_ss"     , sip_media_ss->get_value_as_int() );

    options->setInt("half-closed_hh"   , half_closed_hh->get_value_as_int() );
    options->setInt("half-closed_mm"   , half_closed_mm->get_value_as_int() );
    options->setInt("half-closed_ss"   , half_closed_ss->get_value_as_int() );

    options->setInt("uauth_hh"        , uauth_hh->get_value_as_int() );
    options->setInt("uauth_mm"        , uauth_mm->get_value_as_int() );
    options->setInt("uauth_ss"        , uauth_ss->get_value_as_int() );
    options->setBool("uauth_abs"      , uauth_abs->get_active() );
    options->setBool("uauth_inact"    , uauth_inact->get_active() );

    options->setInt("pix_telnet_timeout"   , telnet_timeout->get_value_as_int() );
    options->setInt("pix_ssh_timeout"      , ssh_timeout->get_value_as_int() );

    options->setBool("pix_resetinbound"        ,resetinbound->get_active());
    options->setBool("pix_resetoutside"        ,resetoutside->get_active());

    options->setBool("pix_connection_timewait" ,connection_timewait->get_active());
    options->setBool("pix_fragguard"           ,fragguard->get_active());
    options->setBool("pix_floodguard"          ,floodguard->get_active());
    options->setBool("pix_route_dnat"          ,route_dnat->get_active());
    options->setBool("pix_nodnsalias_inbound"  ,nodnsalias_inbound->get_active());
    options->setBool("pix_nodnsalias_outbound" ,nodnsalias_outbound->get_active());

    saveFixups();
}

bool PIXAdvancedFWDialog::run()
{
    ok=false;

// Load data
    wrk2dlg();

    show();
    Gtk::Main::grab_add(*this);
    Gtk::Main::run();
    Gtk::Main::grab_remove(*this);
    hide();

    if (ok) {
// save data
        dlg2wrk();
    }
    return ok;
}

void PIXAdvancedFWDialog::on_ok_clicked()
{   
/* first need to check some parameters */
    string v=syslog_device_id_string_val->get_text();
    if (v.find(" ")!=string::npos ||
        v.find("&")!=string::npos ||
        v.find("'")!=string::npos ||
        v.find("\"")!=string::npos ||
        v.find("<")!=string::npos ||
        v.find(">")!=string::npos ||
        v.find("?")!=string::npos)
    {
        MessageDialog::Error("syslog device id string may not contain space,&, ', \", <, > or ? characters");
        return;
    }

    ok=true;
    Gtk::Main::quit();
}

void PIXAdvancedFWDialog::on_cancel_clicked()
{   
    ok=false;
    Gtk::Main::quit();
}

void PIXAdvancedFWDialog::setDefaultTimeoutValue(const string &option)
{
    FWOptions *options=fwobj->getOptionsObject();
    assert(options!=NULL);

    string vers="version_"+fwobj->getStr("version");

    Resources::platform_res["pix"]->setDefaultOption(options,
                "/FWBuilderResources/Target/options/"+vers+"/timeouts/"+option+"_hh");
    Resources::platform_res["pix"]->setDefaultOption(options,
                "/FWBuilderResources/Target/options/"+vers+"/timeouts/"+option+"_mm");
    Resources::platform_res["pix"]->setDefaultOption(options,
                "/FWBuilderResources/Target/options/"+vers+"/timeouts/"+option+"_ss");
}

void PIXAdvancedFWDialog::on_default_timeouts_clicked()
{
    FWOptions *options=fwobj->getOptionsObject();
    assert(options!=NULL);
    
    string vers="version_"+fwobj->getStr("version");

    setDefaultTimeoutValue("xlate"       );
    setDefaultTimeoutValue("conn"        );
    setDefaultTimeoutValue("udp"         );
    setDefaultTimeoutValue("rpc"         );
    setDefaultTimeoutValue("h323"        );
    setDefaultTimeoutValue("sip"         );
    setDefaultTimeoutValue("sip_media"   );
    setDefaultTimeoutValue("half-closed" );
    setDefaultTimeoutValue("uauth"       );

    Resources::platform_res["pix"]->setDefaultOption(options,
                "/FWBuilderResources/Target/options/"+vers+"/timeouts/uauth_abs");
    Resources::platform_res["pix"]->setDefaultOption(options,
                "/FWBuilderResources/Target/options/"+vers+"/timeouts/uauth_inact");

    Resources::platform_res["pix"]->setDefaultOption(options,
                "/FWBuilderResources/Target/options/"+vers+"/timeouts/telnet_timeout");
    Resources::platform_res["pix"]->setDefaultOption(options,
                "/FWBuilderResources/Target/options/"+vers+"/timeouts/ssh_timeout");
    
    wrk2dlg();
}

void PIXAdvancedFWDialog::showFixups()
{
    ostringstream str;
        
    for (list<fixupControl>::iterator fi=allFixups.begin(); fi!=allFixups.end(); fi++)
    {
        if (!fi->active) continue;

        string name=fi->fwoption;
        string sw  =fi->switch_widget->get_value();
        int    p1=(fi->arg1)?fi->arg1->get_value_as_int():0;
        int    p2=(fi->arg2)?fi->arg2->get_value_as_int():0;
        bool   op=(fi->arg3)?fi->arg3->get_active():false;

        str << _printFixupCommand(fi->fixup_cmd,sw,p1,p2,op);
    }

    pix_generated_fixup->set_point(0);
    pix_generated_fixup->forward_delete( pix_generated_fixup->get_length() );
    pix_generated_fixup->insert( str.str() );
}

/*
 * This is a copy of the method  OSConfigurator_pix_os::_printFixupCommand
 */
string PIXAdvancedFWDialog::_printFixupCommand(const string &fixup_name,
                                               const string &sw,
                                               int   arg1, 
                                               int   arg2,
                                               bool  ov)
{
    ostringstream res;

    if (sw=="0")
    {
        if (fixup_name=="dns")
        {
            if (arg1)
            {
                res << "fixup protocol " << fixup_name;
                res << " maximum-length " << arg1;
                res << endl;
            }
        } else
        {
            if (fixup_name=="ftp")
            {
                if (arg1)
                {
                    res << "fixup protocol " << fixup_name << " ";
                    if (ov) res << "strict ";
                    res << arg1;
                    res << endl;
                }
            } else
            {
                if (fixup_name=="mgcp")
                {
                    if (arg1)
                    {
                        res << "fixup protocol " << fixup_name << " ";
                        res << arg1;
                        res << endl;
                    }
                    if (arg2) 
                    {
                        res << "fixup protocol " << fixup_name << " ";
                        res << arg2;
                        res << endl;
                    }
                } else 
                {
                    res << "fixup protocol " << fixup_name << " ";
                    if (arg1) res << arg1;
                    if (arg2 && arg1!=arg2) res << "-" << arg2;
                    res << endl;
                }
            }
        }
    }
    if (sw=="1")
    {
        res << "no fixup protocol " << fixup_name;
        res << endl;
    }

    return res.str();
}


void PIXAdvancedFWDialog::on_fixup_cmd_changed()
{  
    showFixups();
}


