/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PIXAdvancedFWDialog.hh,v 1.2 2003/09/22 04:48:39 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _PIXADVANCEDFWDIALOG_HH
#  include "PIXAdvancedFWDialog_glade.hh"
#  define _PIXADVANCEDFWDIALOG_HH
#include "glademm_support.hh"

#include "fwbuilder/Firewall.hh"

struct fixupControl {
    class OptionMenuWidget *switch_widget;
    class Gtk::SpinButton  *arg1;
    class Gtk::SpinButton  *arg2;
    class Gtk::CheckButton *arg3;
    string                 fwoption;
    string                 fixup_cmd;
    int                    page;     // number of the notebook page in fixup_notebook widget
    bool                   active;   // if false, then this fixup is not supported on the given version of PIX OS
    fixupControl(class OptionMenuWidget *s,
                 class Gtk::SpinButton  *w1,
                 class Gtk::SpinButton  *w2,
                 class Gtk::CheckButton *w3,
                 const string &o,
                 const string &f,
                 int           p)
    { switch_widget=s; arg1=w1; arg2=w2; arg3=w3; fwoption=o; fixup_cmd=f; page=p; active=true; }
};


class PIXAdvancedFWDialog : public PIXAdvancedFWDialog_glade
{   
    friend class PIXAdvancedFWDialog_glade;

    libfwbuilder::Firewall *fwobj;
    bool ok;
    std::map<std::string,std::string>  log_facilities;
    std::map<std::string,std::string>  log_levels;

    std::list<struct fixupControl>     allFixups;

    void on_ok_clicked();
    void on_cancel_clicked();
    void on_changed();
    void on_default_timeouts_clicked();
    void on_default_fixups_clicked();
    void on_fixup_cmd_changed();

    void wrk2dlg();
    void dlg2wrk();

    void setDefaultTimeoutValue(const string &option);
    
    void loadFixups();
    void saveFixups();
    void showFixups();

    std::string _printFixupCommand(const string &fixup_name,
                                   const string &sw,
                                   int   arg1, 
                                   int   arg2,
                                   bool  ov);

    public:

    PIXAdvancedFWDialog(libfwbuilder::Firewall *fobj);

    bool run();
};

#endif
