/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ScriptEditor.cc,v 1.1 2002/11/26 05:24:37 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "ScriptEditor.hh"

#include "FileSel.hh"
#include "MessageDialog.hh"
#include "Preferences.hh"

#include <fstream>


ScriptEditor::ScriptEditor(const std::string &txt)
{
    set_usize(350, 450);

    script->set_point(0);
    script->forward_delete( script->get_length() );
    script->insert(txt);
    choice=false;
}

bool ScriptEditor::run()
{
    Gtk::Main::grab_add(*this);
    Gtk::Main::run();
    Gtk::Main::grab_remove(*this);
    return choice;
}

string ScriptEditor::getScript()
{
    return script->get_chars(0,script->get_length());
}


void ScriptEditor::on_ok_clicked()
{   
    Gtk::Main::quit();
    choice=true;
}

void ScriptEditor::on_cancel_clicked()
{   
    Gtk::Main::quit();
    choice=false;
}

void ScriptEditor::on_import_clicked()
{   
    MessageDialog::DlgReturnValue a=MessageDialog::OK_YES;
    if ( script->get_length()!=0 )
        a = MessageDialog::YesNo(
"Loading from file discards current contents of the script.\n\
Are you sure you want to do this?"
        );

    if (a==MessageDialog::OK_YES)
    {
        FileSel *fs=new FileSel("Find script file",
                                Preferences::global_prefs->getWdir(),
                                "");
        string filename=fs->run();
        delete fs;
        if(filename!="")
        {
            ifstream ifile(filename.c_str());
            if (!ifile)
            {
                MessageDialog::Error("Could not open file "+filename);
                return;
            }

            string text;
            char buf[1024];
            while (ifile.getline(buf,1024)) { text+=buf; text+="\n"; }

            script->set_point(0);
            script->forward_delete( script->get_length() );
            script->insert(text);
        }
    }
}

