/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TargetDialog_pix_os.cc,v 1.1 2002/11/26 05:24:37 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Firewall.hh"

#include "TargetDialog_pix_os.hh"
#include "PIXAdvancedNetDialog.hh"


using namespace libfwbuilder;

DialogPlugin* create_dialog_pix_os(FWObject *o)
{
    return new TargetDialog_pix_os(o);
}

TargetDialog_pix_os::TargetDialog_pix_os(FWObject *obj)
{
    object=obj;

    fwoptions=(Firewall::cast(object))->getOptionsObject();
    assert(fwoptions!=NULL);

    ((Gtk::Label*)(pix_set_host_name->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(pix_ip_address->get_child()))->set_alignment(0.0,1.0);

    options.push_back( DialogOption( pix_set_host_name , "pix_set_host_name" ) );
    options.push_back( DialogOption( pix_ip_address    , "pix_ip_address"    ) );
}


void TargetDialog_pix_os::on_changed()
{   
    DialogPlugin::data_changed_flag(true);
}

void TargetDialog_pix_os::on_pix_advanced_net_clicked()
{   
    PIXAdvancedNetDialog *pand=new PIXAdvancedNetDialog(Firewall::cast(object));    pand->run();
    delete pand;
    on_changed();

}


void TargetDialog_pix_os::readDefaults()
{
}

void TargetDialog_pix_os::wrk2dlg()
{
    loadPageOptions(fwoptions,  options);
}

bool TargetDialog_pix_os::dlg2wrk()
{
    savePageOptions(fwoptions,  options );
    return true;
}
