#!/bin/sh
#
#  Firewall Builder
#
#  Copyright (C) 2002 NetCitadel, LLC
#
#
#
# this script performs upgrade of Firewall Builder data file by running
# appropriate XSLT transformations sequentially until version becomes
# current.
#
#   Author: Vadim Kurland, <vadim@fwbuilder.org>
#

XMLFILE=$1
VER=$2

if test -z "${XMLFILE}"; then
 echo "Usage: fwb-upgrade.sh xml_data_file"
 exit 1
fi

XSLTPROC=`which xsltproc`
if test -z "${XSLTPROC}"; then
 echo "Can't find xsltproc, check if you have libxslt installed"
 exit 1
fi



INST_DIR="/usr/share/libfwbuilder"
TMP1=".fwb.upgr.xml"
FILE=$XMLFILE

cp ${FILE} ${FILE}.bak

LIBFWBUILDER_CONFIG=`which libfwbuilder-config 2>/dev/null`
if test -n "${LIBFWBUILDER_CONFIG}"; then
  CURRENT_VERSION=$(${LIBFWBUILDER_CONFIG} --version)
  INST_DIR=$(${LIBFWBUILDER_CONFIG} --templatedir)
else
  DTDFILE=${INST_DIR}/fwbuilder.dtd
  CURRENT_VERSION=$(sed -n '/FWObjectDatabase/,/version/s/.*version[^"]*"//p' ${DTDFILE} | sed 's/"//')
fi

test -n "$VER" && CURRENT_VERSION=$VER


while :;
do
  FILE_VERSION=$(echo "
<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">
<xsl:output method=\"text\"/>
<xsl:strip-space elements=\"*\"/>
<xsl:template match=\"*[attribute::id='root']\">
<xsl:value-of select=\"@version\"/>
</xsl:template>
</xsl:stylesheet>
" | ${XSLTPROC} --novalid - $XMLFILE 2>/dev/null)

  if test "$FILE_VERSION" = "$CURRENT_VERSION"; then
    break
  fi

  echo "check for empty namespaces"
#
# need to fix a bug with namespaces
# All elements now have a namespace prefix:
# <fwb:ServiceGroup id="stdid10" library="Standard" name="Groups">
# while those added by transformation 0.10.7->0.10.8 dont:
# <Host xmlns="" address="whatever" comment="" id="id3FE46C26" name="somehost">
#
  cat $XMLFILE | perl -ne "\$_=~s/xmlns=\"\"//; print $_;" > $TMP1
  mv $TMP1 $FILE

  TRANSFORMATION="${INST_DIR}/migration/${FILE_VERSION}/FWObjectDatabase.xslt"

  if test -f ${TRANSFORMATION}; then
    echo ${FILE_VERSION}

#    VFILE=`basename $FILE .xml`-${FILE_VERSION}.xml
#    cp $FILE ${VFILE}

    ${XSLTPROC} ${TRANSFORMATION} $FILE > $TMP1 2>/dev/null  || {
      echo "Error running xsltproc"
      exit 1
    }

    mv $TMP1 $FILE
  else
    echo "Missing transformation script ${TRANSFORMATION}"
    exit 1
  fi
done


echo '*******************************************************'
echo
echo "File $XMLFILE has been upgraded, current version is $CURRENT_VERSION"
echo
echo "Backup copy is in ${XMLFILE}.bak"
echo

exit

