#!/usr/bin/perl -s
# $Id: survey2csv.pl,v 1.3 2001/07/06 17:11:30 vkurland Exp $

sub urldecode
  {
    local($val)=@_;
    $val=~s/\+/ /g;
    $val=~s/%([0-9A-H]{2})/pack('C',hex($1))/ge;
    return $val;
  }

sub trim
  {
    my @out = @_;
    for (@out) {
      s/^\s+//;
      s/\s+$//;
    }
    return wantarray? @out: $out[0];
  }

my $first=1;

#all possible keys
%keys_types = (
               "linux_red_hat" => "yesno",
               "linux_debian" => "yesno",
               "linux_mandrake" => "yesno",
               "linux_suse" => "yesno",
               "freebsd" => "yesno",
               "openbsd" => "yesno",
               "bsdi" => "yesno",
               "solaris" => "yesno",
               "win" => "yesno",
               "appliance" => "yesno",
               "other_os_name" => "text",
           
               "use_free" => "yesno",
               "use_under_2k" => "yesno",
               "use_under_10k" => "yesno",
               "use_above_10k" => "yesno",
               "use_vendor_type" => "text",
           
               "personal" => "yesno",
               "small_company" => "yesno",
               "medium_company" => "yesno",
           
               "dontlike_gui" => "yesno",
               "dontlike_ease_of_use" => "yesno",
               "dontlike_ease_of_install" => "yesno",
               "dontlike_support" => "yesno",
               "dontlike_compilers" => "yesno",
               "dontlike_pace_of_releases" => "yesno",
               "dontlike_reactivity" => "yesno",
               "dontlike_other" => "text",

               "like_gui" => "yesno",
               "like_ease_of_use" => "yesno",
               "like_ease_of_install" => "yesno",
               "like_support" => "yesno",
               "like_compilers" => "yesno",
               "like_pace_of_releases" => "yesno",
               "like_reactivity" => "yesno",
               "like_other" => "text",

               "add_checkpoint" => "yesno",
               "add_cisco" => "yesno",
               "add_cyberguard" => "yesno",
               "add_microsoft" => "yesno",
               "add_netscreen" => "yesno",
               "add_nokia" => "yesno",
               "add_na" => "yesno",
               "add_rapidstream" => "yesno",
               "add_securecomp" => "yesno",
               "add_sonicwall" => "yesno",
               "add_stonesoft" => "yesno",
               "add_watchguard" => "yesno",
               "add_other" => "text",

               "add_linux_mandrake" => "yesno",
               "add_linux_suse" => "yesno",
               "add_freebsd" => "yesno",
               "add_openbsd" => "yesno",
               "add_bsdi" => "yesno",
               "add_solaris" => "yesno",
               "add_windows" => "yesno",
               "add_other_os" => "text",
           
               "top_feature" => "text",
               "sec_feature" => "text",
               "good_to_have_feature" => "text",
                 
               "migrate" => "text"
              );

@keys = keys %keys_types;

print "Content-type: text/csv\n\n";

open(DATA, "/home/groups/f/fw/fwbuilder/log/fwbuilder_survey.log") || die "error opening data file";

while (<DATA>) {
  my ($d, $ip, $rest) = split /\s+/;
  

  # Clean
  delete @pairs{keys %pairs};

  foreach my $p (split(/\&/, $rest)) {
    my($n, $v) = split(/\=/, $p);
    if (not($n eq "Submit")) {
      $pairs{$n}=$v;
    }
  }

  if ($first==1) {
    $first = 0;
    print "Time, IP Address";
    foreach $key (@keys) {
      print ", $key";
    }
  } else {
    $time_s=gmtime($d);
    print $time_s, ", ", $ip;
    foreach $key (@keys) {
      if ($keys_types{$key} eq "text") {
        my $v=urldecode($pairs{$key});
        $v =~ s/[\r\n]/ /g;
        $v=trim($v);
        if ($v eq "") {
          print ", "
        } else {
          # escape quotes by doubling them
          $v =~ s/\"/\"\"/g;
          # quote commas
          $v =~ s/\,/\;/g;
          print ", \"$v\"";
        }
      } else {
        if ($keys_types{$key} eq "yesno") {
          if ($pairs{$key} eq "yes") {
            print ", 1";
          } else {
            print ", 0";
          }
        } else {
          die "unknown key: $key";
        }
      }
    }
  }
  print "\n";
}

close(DATA);


