/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: ipfAdvancedDialog.cpp,v 1.10.4.1 2005/09/04 20:49:14 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "platforms.h"

#include "ipfAdvancedDialog.h"
#include "SimpleTextEditor.h"

#include "fwbuilder/Firewall.h"
#include "fwbuilder/Management.h"
#include "fwbuilder/Resources.h"

#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qwidgetstack.h>
#include <qregexp.h>
#include <qtextview.h>


using namespace std;
using namespace libfwbuilder;


ipfAdvancedDialog::ipfAdvancedDialog(QWidget *parent,FWObject *o)
    : ipfAdvancedDialog_q(parent)
{
    obj=o;
    QStringList slm;

    FWOptions *fwopt=(Firewall::cast(obj))->getOptionsObject();
    assert(fwopt!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    if (fwbdebug)
        qDebug("%s",Resources::getTargetOptionStr(
                   obj->getStr("host_OS"),"user_can_change_install_dir").c_str());

    if (!Resources::getTargetOptionBool(
            obj->getStr("host_OS"),"user_can_change_install_dir"))
    {
        ipf_fw_dir->setEnabled(false);
        fwopt->setStr("firewall_dir","");
    }

    data.registerOption( ipf_log_or_block         ,fwopt, "ipf_log_or_block"    );
    data.registerOption( ipf_log_body             ,fwopt, "ipf_log_body"        );
    data.registerOption( ipf_check_shadowing      ,fwopt, "check_shading"       );
    data.registerOption( ipf_eliminate_duplicates ,fwopt, "eliminate_duplicates");
    data.registerOption( ipf_accept_new_tcp_with_no_syn ,fwopt, "accept_new_tcp_with_no_syn");
    data.registerOption( ipf_in_out_code          ,fwopt, "in_out_code"   );
    data.registerOption( ipf_pass_all_out         ,fwopt, "pass_all_out"  );
    data.registerOption( ipf_ignore_empty_groups  ,fwopt, "ignore_empty_groups");
    data.registerOption( ipf_return_icmp_as_dest  ,fwopt, "ipf_return_icmp_as_dest");
    data.registerOption( ipf_nat_raudio_proxy     ,fwopt, "ipf_nat_raudio_proxy");
    data.registerOption( ipf_nat_h323_proxy       ,fwopt, "ipf_nat_h323_proxy");
    data.registerOption( ipf_nat_ipsec_proxy      ,fwopt, "ipf_nat_ipsec_proxy");
    data.registerOption( ipf_nat_ftp_proxy        ,fwopt, "ipf_nat_ftp_proxy");
    data.registerOption( ipf_nat_rcmd_proxy       ,fwopt, "ipf_nat_rcmd_proxy");
    data.registerOption( ipf_fw_dir               ,fwopt, "firewall_dir"      );
    data.registerOption( ipf_user                 ,fwopt, "admUser"           );
    data.registerOption( altAddress               ,fwopt, "altAddress"        );
    data.registerOption( sshArgs                  ,fwopt, "sshArgs"           );
    data.registerOption( activationCmd            ,fwopt, "activationCmd"     );

    data.registerOption( ipf_manage_virtual_addr  ,fwopt, "manage_virtual_addr");
    data.registerOption( ipf_configure_interfaces ,fwopt, "configure_interfaces");
    data.registerOption( ipf_debug                ,fwopt, "debug"            );
    data.registerOption( ipf_optimize             ,fwopt, "optimize"  );
    data.registerOption( ipf_dynAddr              ,fwopt, "dynAddr"   );

    slm = getLogLevels( obj->getStr("platform").c_str() );
    logLevel->clear();
    logLevel->insertStringList( getScreenNames( slm ));
    data.registerOption( logLevel             , fwopt,  "ipf_log_level" ,   slm);

    slm = getLogFacilities( obj->getStr("platform").c_str() );
    logFacility->clear();
    logFacility->insertStringList( getScreenNames( slm ));    
    data.registerOption( logFacility          , fwopt,  "ipf_log_facility", slm);

    data.registerOption( compiler             , fwopt,  "compiler" );
    data.registerOption( compilerArgs         , fwopt,  "cmdline"  );
    data.registerOption( outputFileName       , fwopt,  "output_file"  );

    slm=getActionsOnReject( obj->getStr("platform").c_str() );
    actionOnReject->clear();
    actionOnReject->insertStringList(getScreenNames(slm));

    data.registerOption( actionOnReject       , fwopt,  "action_on_reject",slm);
    data.registerOption( mgmt_ssh             , fwopt,  "mgmt_ssh"  );
    data.registerOption( mgmt_addr            , fwopt,  "mgmt_addr" );

    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

    installScript->setText(     pis->getCommand().c_str() );
    installScriptArgs->setText( pis->getArguments().c_str() );

/* page "Prolog/Epilog" */
    data.registerOption( prolog_script    , fwopt,  "prolog_script"  );

    data.registerOption( epilog_script    , fwopt,  "epilog_script"  );

    data.loadAll();
}

/*
 * store all data in the object
 */
void ipfAdvancedDialog::accept()
{
    FWOptions *fwopt=(Firewall::cast(obj))->getOptionsObject();
    assert(fwopt!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    data.saveAll();

    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();
    pis->setCommand( installScript->text().latin1() );
    pis->setArguments( installScriptArgs->text().latin1() );

    ipfAdvancedDialog_q::accept();
}

void ipfAdvancedDialog::reject()
{
    ipfAdvancedDialog_q::reject();
}

void ipfAdvancedDialog::editProlog()
{
    SimpleTextEditor edt( prolog_script->text(),
                          true, tr( "Script Editor" ) );
    if ( edt.exec() == QDialog::Accepted )
        prolog_script->setText( edt.text() );
}

void ipfAdvancedDialog::editEpilog()
{
    SimpleTextEditor edt( epilog_script->text(),
                          true, tr( "Script Editor" ) );
    if ( edt.exec() == QDialog::Accepted )
        epilog_script->setText( edt.text() );
}



