/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: FWObjectDropArea.cpp,v 1.1 2006/05/06 23:33:53 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"
#include "platforms.h"
#include "definitions.h"

#include "FWObjectDropArea.h"
#include "FWObjectDrag.h"
#include "FWObjectClipboard.h"

#include "fwbuilder/Resources.h"

#include <qpainter.h>
#include <qrect.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qpopupmenu.h>

#include <iostream>
#include <stdlib.h>

using namespace std;
using namespace libfwbuilder;

FWObjectDropArea::FWObjectDropArea(QWidget*p, const char * n, WFlags f) : FWObjectDropArea_q(p,n,f) 
{
    object=NULL;

}
void FWObjectDropArea::paintEvent(QPaintEvent *ev)
{
    int w=width();
    int h=height();
        
    QPainter p(this);
    
    QPixmap bufferpixmap;
    bufferpixmap.resize( w , h );
    bufferpixmap.fill( Qt::white );
    QPainter tp( &bufferpixmap );

    tp.setBrush(Qt::black);
    tp.drawLine(0,0,w-1,0);
    tp.drawLine(w-1,0,w-1,h-1);
    tp.drawLine(w-1,h-1,0,h-1);
    tp.drawLine(0,h-1,0,0);
    
    if (object!=NULL) 
    {

        QPixmap pm = getPixmap(object);

        tp.drawPixmap( ((w-pm.width())/2), (h/2)-(2+pm.height()) , pm );
        
        QString t=QString::fromUtf8(object->getName().c_str());
        
        int t_x=2;
        int t_y=2+h/2;
        int t_w=w-4;
        int t_h=h/2-4;
        
        tp.drawText( t_x, t_y , t_w, t_h ,
                     Qt::AlignHCenter|Qt::AlignTop|Qt::WordBreak, t );
    }
    else
    {
        QString t=tr("Drop object here.");
        
        int t_x=2;
        int t_y=2;
        int t_w=w-4;
        int t_h=h-4;

        tp.drawText( t_x, t_y , t_w, t_h ,
                     Qt::AlignHCenter|Qt::AlignVCenter|Qt::WordBreak, t );

        
    }
    tp.end();
    p.drawPixmap( 0, 0, bufferpixmap );
    
}
void FWObjectDropArea::insertObject(libfwbuilder::FWObject *o)
{
    if (object!=o)
    {
        object=o;
        update();
        emit objectInserted();
    }
}
void FWObjectDropArea::deleteObject()
{
    object=NULL;
    update();
    emit objectDeleted();
}
QPixmap FWObjectDropArea::getPixmap(FWObject *obj) const
{
    QPixmap pm;
    string icn = "icon";
    //if (pmattr == Neg)  icn="icon-neg";
    //if (pmattr == Ref)  icn="icon-ref";
    //if (pmattr == Tree) icn="icon-tree";
    //
    icn="icon-tree";
    
    return QPixmap::fromMimeSource( 
        Resources::global_res->getObjResourceStr(obj, icn).c_str() );
}
void FWObjectDropArea::contextMenuEvent (QContextMenuEvent * e)
{
    QPopupMenu *popup;
    
    popup=new QPopupMenu(this);
    int psId = popup->insertItem( tr("Paste") ,    this , SLOT( pasteObject( )) );
    popup->insertSeparator();
    int dlId = popup->insertItem( tr("Delete") ,   this , SLOT( deleteObject( )) );
    
    popup->setItemEnabled(dlId,object!=NULL);
    popup->setItemEnabled(psId,FWObjectClipboard::obj_clipboard->size()>0);
    
    popup->exec(e->globalPos ());
    delete popup;
}
void FWObjectDropArea::dropEvent( QDropEvent *ev)
{
    if (fwbdebug)
    {
        qDebug("FWObjectDropArea::dropEvent  drop event mode=%d", ev->action());
        qDebug("                        src widget = %p", ev->source());
    }
    
    list<FWObject*> dragol;
    if (FWObjectDrag::decode(ev, dragol))
    {
        if (dragol.size()>0)
        {
            insertObject(dragol.front());
        }
    }
}
void FWObjectDropArea::dragEnterEvent( QDragEnterEvent *ev)
{
    ev->acceptAction( FWObjectDrag::canDecode(ev) );
}
void FWObjectDropArea::pasteObject()
{
    vector<FWObject*>::iterator i;
    i= FWObjectClipboard::obj_clipboard->begin();
    if (i!=FWObjectClipboard::obj_clipboard->end())
    {
        FWObject *co= *i;
        insertObject(co);
    }
    
}
