/* 

                          Firewall Builder

                 Copyright (C) 2006 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: FindObjectWidget.cpp,v 1.6 2006/06/13 06:54:24 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"
#include "platforms.h"
#include "definitions.h"

#include "FindObjectWidget.h"
#include "ObjectManipulator.h"
#include "FWWindow.h"
#include "FWObjectDropArea.h"
#include "ObjectManipulator.h"
#include "FWBTree.h"
#include "FWBSettings.h"
#include "ObjectTreeView.h"
#include "RuleSetView.h"
#include "ObjectEditor.h"


#include "fwbuilder/FWObjectDatabase.h"
#include "fwbuilder/FWReference.h"
#include "fwbuilder/RuleSet.h"
#include "fwbuilder/RuleElement.h"
#include "fwbuilder/Firewall.h"
#include "fwbuilder/IPService.h"
#include "fwbuilder/ICMPService.h"
#include "fwbuilder/TCPService.h"
#include "fwbuilder/UDPService.h"

#include <qwidgetstack.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qcursor.h>
#include <qregexp.h>
#include <qapplication.h>
#include <qmessagebox.h>
#include <qpushbutton.h>

#include <iostream>
#include <stdlib.h>

using namespace std;
using namespace libfwbuilder;

#define MAX_SEARCH_ITEMS_COUNT 10

FindObjectWidget::FindObjectWidget(QWidget*p, const char * n, WFlags f) : findObjectWidget_q(p,n,f) 
{
    replaceDisable();
    srScope->setCurrentItem(st->readNumEntry("/FirewallBuilder2/Search/Scope"));
}
void FindObjectWidget::findObject(FWObject *o)
{
    if (fwbdebug) qDebug("FindObjectWidget::findObject");
    
    findDropArea->insertObject(o); 

}


void FindObjectWidget::enableAll()
{
    //useRegexp->setEnabled (true);
    findAttr->setEnabled  (true);
    attribute->setEnabled (true);
}
void FindObjectWidget::disableAll()
{
    //useRegexp->setEnabled (false);
    findAttr->setEnabled  (false);
    attribute->setEnabled (false);
}
void FindObjectWidget::objectInserted()
{
    FWObject *o=findDropArea->getObject();
    if (o==NULL) return;
    disableAll();
    
    QString n=QString::fromUtf8(o->getName().c_str());
    
    if (findAttr->count()>=MAX_SEARCH_ITEMS_COUNT)
        findAttr->removeItem(MAX_SEARCH_ITEMS_COUNT-1);
    
    findAttr->setCurrentText (n);
    
     reset();
}


void FindObjectWidget::reset()
{
    lastFound=NULL;
    lastAttrSearch="";
    treeSeeker=mw->db()->tree_begin();
}


void FindObjectWidget::findAttrChanged(const QString &ns)
{
    if (ns!=lastAttrSearch)  reset();
    lastAttrSearch=ns;
}

void FindObjectWidget::find()
{
    if (findAttr->currentText().isEmpty() &&
        findDropArea->isEmpty()) return;

    if (findAttr->currentText() != findAttr->text(0))
    {
        if (findAttr->count()>=MAX_SEARCH_ITEMS_COUNT)
            findAttr->removeItem(MAX_SEARCH_ITEMS_COUNT-1);

        findAttr->insertItem( findAttr->currentText() , 0 );

        if (fwbdebug)
            qDebug("FindObjectWidget::find() : findAttr->text(0)=%s",
                   findAttr->text(0).latin1());
    }
    findNext();
}

bool FindObjectWidget::matchID(const QString &id)
{
    if (findDropArea->isEmpty()) return true;
    QString s=QString::fromUtf8(findDropArea->getObject()->getId().c_str() );
    
    return s==id;
}
bool FindObjectWidget::matchAttr(libfwbuilder::FWObject *obj)
{
    if (!findDropArea->isEmpty()) return true;
    QString s=findAttr->currentText();
    if (s.isEmpty()) return true;

    bool res=false;
    int  attrN = attribute->currentItem();

    switch (attrN) {
    case 0:   // Name
    {
        QString name=QString::fromUtf8( obj->getName().c_str() );
        /*
        if (useRegexp->isChecked()) res= ( name.find( QRegExp(s) )!=-1 );
        else                        res= ( name == s );
        */
        res= ( name == s );
        break;
        
    }
    case 1:   // Address
    {
        Address *a = Address::cast(obj);
        if (a!=NULL)
        {
            QString addr = a->getAddress().toString().c_str();
            /*
            if (useRegexp->isChecked()) res= ( addr.find( QRegExp(s) )!=-1 );
            else                        res= ( addr == s );
            */
            res= ( addr == s );
        }
        break;
    }
    case 2:   // port
        if (TCPService::cast(obj)!=NULL || UDPService::cast(obj)!=NULL)
        {
            /*
            if (useRegexp->isChecked()) 
            {
                QString port;
                port.setNum(obj->getInt("src_range_start"));
                res |= ( port.find( QRegExp(s) )!=-1 );
                port.setNum(obj->getInt("src_range_end"));
                res |= ( port.find( QRegExp(s) )!=-1 );
                port.setNum(obj->getInt("dst_range_start"));
                res |= ( port.find( QRegExp(s) )!=-1 );
                port.setNum(obj->getInt("dst_range_end"));
                res |= ( port.find( QRegExp(s) )!=-1 );
            } else
            {
            */
                int port = s.toInt();
                res |= (port == obj->getInt("src_range_start"));
                res |= (port == obj->getInt("src_range_end"));
                res |= (port == obj->getInt("dst_range_start"));
                res |= (port == obj->getInt("dst_range_end"));
            //}
            break;
        }
    case 3:   // protocol num.
        if (IPService::cast(obj)!=NULL)
        {
            /*
            if (useRegexp->isChecked()) 
            {
                QString proto;
                proto.setNum(obj->getInt("protocol_num"));
                res |= ( proto.find( QRegExp(s) )!=-1 );
            } else
            {
            */
                int proto = s.toInt();
                res |= (proto == obj->getInt("protocol_num"));
            //}
            break;
        }
    case 4:   // icmp type
        if (ICMPService::cast(obj)!=NULL)
        {
            /*
            if (useRegexp->isChecked()) 
            {
                QString icmptype;
                icmptype.setNum(obj->getInt("type"));
                res |= ( icmptype.find( QRegExp(s) )!=-1 );
            } else
            {
            */
                int icmptype = s.toInt();
                res |= (icmptype == obj->getInt("type"));
            //}
            break;
        }
    }

    return res;
}

void FindObjectWidget::findNext()
{
    if (fwbdebug) qDebug("FindObjectWidget::findNext");
    if (
        findAttr->currentText().isEmpty() &&
        findDropArea->isEmpty()) return;

    if (findAttr->count()>MAX_SEARCH_ITEMS_COUNT)  
        findAttr->removeItem(0);

    FWObject *o=NULL;

loop:

    QApplication::setOverrideCursor( QCursor( Qt::WaitCursor) );

    for (; treeSeeker!=mw->db()->tree_end(); ++treeSeeker)
    {
        o = *treeSeeker;

        if( RuleElement::cast(o->getParent())!=NULL)
        {
            if (srScope->currentItem()==3) // scope == selected firewalls
            {
                if ( !inSelectedFirewall(RuleElement::cast(o->getParent())) )
                {
                    continue;
                    
                }
            } else if (srScope->currentItem()==0) continue ; // scope == tree only
        } else
        {
/* if not in rules, then in the tree. */
            if (srScope->currentItem()>1) continue; // scope in (firewalls only , selected firewalls)
        }

        if (FWReference::cast(o)!=NULL)
        {
            FWReference *r=FWReference::cast(o);
            if ( 
                matchAttr( r->getPointer() ) &&
                matchID( QString::fromUtf8(r->getPointer()->getId().c_str()) )) break;
        } else
        {
            if (
                matchAttr( o ) &&
                matchID( QString::fromUtf8(o->getId().c_str()) )) break;
        }
    }

    QApplication::restoreOverrideCursor();

    if (treeSeeker==mw->db()->tree_end())
    {
        reset();
        if (srScope->currentItem()==3) // scope ==selected firewalls
        {
            if ( QMessageBox::warning(
                     this,"Firewall Builder", 
                     tr("Search hit the end of the policy rules."),
                     tr("&Continue at top"), tr("&Stop"), QString::null, 0, 1 )==0 ) goto loop;
        }
        else
        {
            if (fwbdebug) qDebug("widget that has focus: %p",mw->focusWidget());
            bool r= ( QMessageBox::warning(
                     this,"Firewall Builder", 
                     tr("Search hit the end of the object tree."),
                     tr("&Continue at top"), tr("&Stop"), QString::null, 0, 1 )==0 );
            if (fwbdebug) qDebug("widget that has focus: %p",mw->focusWidget());
            if (r)  goto loop;
        }
        return;
    }
    assert(o!=NULL);
    lastFound=o;
/* found object. Shift iterator so it does not return the same object
 * when user hits 'find next'
 */
   
    ++treeSeeker;
    
    showObject(o);
    
    if (fwbdebug)
    {
        qDebug("Found object: o=%p  id=%s  name=%s  type=%s",
               o, o->getId().c_str(),o->getName().c_str(),o->getTypeName().c_str());
    }
}

bool FindObjectWidget::validateReplaceObject()
{
    if (findDropArea->isEmpty() || replaceDropArea->isEmpty()) 
    {
        QMessageBox::warning(
              this,"Firewall Builder", 
              tr("Search or Replace object ind't specified."));
        return false;
    }
    FWObject *findObj, *replObj;
    findObj=findDropArea->getObject();
    replObj=replaceDropArea->getObject();
    if (findObj==replObj || findObj->getId() == replObj->getId())
    {
        QMessageBox::warning(
              this,"Firewall Builder", 
              tr("Cannot replace object by itself."));
        return false;
    }
    if (!((Address::cast(findObj)!=NULL && Address::cast(replObj)) ||
            (Service::cast(findObj)!=NULL && Service::cast(replObj))))
    {
        QMessageBox::warning(
              this,"Firewall Builder", 
              tr("Search and Replace objects are incompatible."));
        
        return false;
    }
    return true;
}
void FindObjectWidget::replace()
{
    if(!validateReplaceObject())  return;
    

    if (lastFound==NULL) 
    {
        find();
        return;
    }
    
    QApplication::setOverrideCursor( QCursor( Qt::WaitCursor) );
    FWObject *res=_replaceCurrent();
    mw->updateRuleSetView();
    om->info();
    if (res) 
    {
        showObject(res);
    }
    else
    {
        // object isn't inserted
        qDebug("object isn't inserted");
    }
    
    QApplication::restoreOverrideCursor();
}
    
void FindObjectWidget::replaceAll()
{
    if(!validateReplaceObject()) return;
    reset();
    FWObject *o=NULL;
    int count=0;
    bool f=true;
    
    QApplication::setOverrideCursor( QCursor( Qt::WaitCursor) );
    while (f)
    {
        for (; treeSeeker!=mw->db()->tree_end(); ++treeSeeker)
        {
            o = *treeSeeker;
            if( RuleElement::cast(o->getParent())!=NULL)
            {
                if (srScope->currentItem()==3) // scope == selected firewalls
                {
                    if ( !inSelectedFirewall(RuleElement::cast(o->getParent())) )
                    {
                        continue;
                        
                    }
                } else if (srScope->currentItem()==0) continue ; // scope == tree only
            } else
            {
    /* if not in rules, then in the tree. */
                if (srScope->currentItem()>1) continue; // scope in (firewalls only , selected firewalls)
            }

            if (FWReference::cast(o)!=NULL)
            {
                FWReference *r=FWReference::cast(o);
                if ( 
                     matchAttr( r->getPointer() ) &&
                     matchID( QString::fromUtf8(r->getPointer()->getId().c_str()) )) break;
            } else
            {
                if (
                    matchAttr( o ) &&
                    matchID( QString::fromUtf8(o->getId().c_str()) )) break;
            }
        }
        if (treeSeeker==mw->db()->tree_end())
        { 
            f=false;
            
        } else
        {
            lastFound=o;
            ++treeSeeker;
            count++;
            _replaceCurrent();
        }
    }
    mw->updateRuleSetView();
    om->info();
    QApplication::restoreOverrideCursor();
    QMessageBox::information(
              this,"Firewall Builder", 
              tr("Replaced %1 objects.").arg(count));

}
FWObject* FindObjectWidget::_replaceCurrent()
{
    FWObject *o=lastFound;
    FWObject *p=lastFound->getParent();

    if (p==NULL || o==NULL) return NULL;
    if (FWReference::cast(o)==NULL) return NULL;
    
    p->removeRef(FWReference::cast(o)->getPointer());
    //chack for duplicates --------
    
    FWObject *ro=replaceDropArea->getObject();
    if (RuleElement::cast(p)==NULL || !RuleElement::cast(p)->isAny())
    {
/* avoid duplicates */
        string cp_id=ro->getId();
        FWObject *oo;
        FWReference *ref;
        
        list<FWObject*>::iterator j;
        for(j=p->begin(); j!=p->end(); ++j)     
        {
            oo=*j;
            if(cp_id==oo->getId()) return NULL;

            if( (ref=FWReference::cast(oo))!=NULL &&
                cp_id==ref->getPointerId()) return NULL;
        }
    }
    
    p->addRef(ro);
    FWObject *to;
    FWReference *ref;
    list<FWObject*>::iterator i;
    string id=replaceDropArea->getObject()->getId();
    for (i=p->begin();i!=p->end();++i)
    {
        to=*i;
        ref=FWReference::cast(to);
        if(ref && ref->getPointerId()==id)
        {
            return to;
        }

    }
    return NULL;

}
bool FindObjectWidget::inSelectedFirewall( RuleElement* r)
{

    FWObject *f=r;
    while (f!=NULL && !Firewall::isA(f)) f=f->getParent();
    if (f==NULL) return false;
    
    return selectedFirewall==(Firewall::cast(f));
}

void FindObjectWidget::replaceEnable()
{
    replaceButton->setEnabled   (true);
    repNextButton->setEnabled   (true);
    replaceAllButton->setEnabled(true);
    
}

void FindObjectWidget::replaceDisable()
{
    replaceButton->setEnabled   (false);
    repNextButton->setEnabled   (false);
    replaceAllButton->setEnabled(false);
    
}

void FindObjectWidget::showObject(FWObject* o)
{
    if (fwbdebug) qDebug("FindObjectWidget::showObject");
    
    FWReference* ref=FWReference::cast(o);
    if (ref!=NULL && RuleElement::cast(o->getParent())!=NULL)
    {
        oe->close();
        om->clearFocus();
        mw->ensureObjectVisibleInRules( ref );
        mw->selectRules();
        return;
    }

    mw->unselectRules();

    if (Group::cast(o->getParent())!=NULL && 
        !FWBTree::isSystem(o->getParent()))
    {
        om->openObject( o->getParent() );
        om->editObject( o->getParent() );
        oe->selectObject( ref->getPointer());
        //oe->setFocus();
        return;
    }

    oe->close();
    om->openObject( o );
    om->select();  // selects an item in the tree and assigns kbd focus to it
}

void FindObjectWidget::init()
{
    findDropArea->deleteObject();
    replaceDropArea->deleteObject();
    hidePanel();
}

void FindObjectWidget::firewallOpened(Firewall *f)
{
    if (f==NULL) return;
    selectedFirewall=f;
    srScope->changeItem(tr("Policy of firewall '")+f->getName().c_str()+"'",3);
}

void FindObjectWidget::findPrev()
{

}

void FindObjectWidget::replaceNext()
{
    replace();
    findNext();
}
void FindObjectWidget::scopeChanged()
{
    st->writeEntry("/FirewallBuilder2/Search/Scope",srScope->currentItem ());
    
}
