/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: instBatchOptionsDialog.cpp,v 1.2 2006/04/17 14:51:43 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"
#include "platforms.h"
#include "definitions.h"

#include "instBatchOptionsDialog.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/FWException.h"
#include "fwbuilder/Firewall.h"

#include <qstring.h>
#include <qlineedit.h>
#include <qlabel.h>

#include <stdlib.h>

using namespace std;
using namespace libfwbuilder;

instBatchOptionsDialog::instBatchOptionsDialog(QWidget *parent) : instOptionsDialog_q(parent)
{
    textLabel1_4->setText(tr("<p align=\"center\"><b><font size=\"+2\">Setup batch install options</font></b></p>"));
    textLabel10->hide();
    altAddress->hide();
    
}

void instBatchOptionsDialog::applyChanges()
{
    hide();
}

void instBatchOptionsDialog::discardChanges()
{
    hide();
}

QString instBatchOptionsDialog::getUName() { return uname->text(); }
QString instBatchOptionsDialog::getPWD()   { return pwd->text();   }
QString instBatchOptionsDialog::getEPWD()  { return epwd->text();  }

void instBatchOptionsDialog::closeEvent(QCloseEvent *e)
{
    if (fwbdebug)
        qDebug("instBatchOptionsDialog::closeEvent  got close event: %p",e);
    hide();
}

