/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: ObjectIconView.cpp,v 1.9 2005/09/07 16:40:50 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"

#include "fwbuilder/FWObjectDatabase.h"
#include "FWWindow.h"
#include "ObjectIconView.h"
#include "ObjectIconViewItem.h"
#include "FWObjectDrag.h"

#include "fwbuilder/FWObject.h"
#include "fwbuilder/Resources.h"

#include <qdragobject.h>
#include <qiconview.h>

#include <iostream>

using namespace std;
using namespace libfwbuilder;

/****************************************************************************
 *
 *    class ObjectIconView
 *
 ****************************************************************************/

ObjectIconView::ObjectIconView(QWidget* parent, const char * name, WFlags f) :
    QIconView(parent,name,f)
{}

QDragObject* ObjectIconView::dragObject()
{
    QIconViewItem      *ivi  = currentItem();
    ObjectIconViewItem *oivi = dynamic_cast<ObjectIconViewItem*>(ivi);
    assert(oivi!=NULL);

    FWObject *obj = oivi->getFWObject();
    QString icn_filename =
        Resources::global_res->getObjResourceStr(obj, "icon-ref").c_str();
    list<FWObject*> dragobj;
    dragobj.push_back(obj);

    FWObjectDrag    *drag = new FWObjectDrag(dragobj, this);
    QPixmap          pm   = QPixmap::fromMimeSource( icn_filename );
    drag->setPixmap( pm,
                     QPoint( pm.rect().width() / 2,
                             pm.rect().height() / 2 ) );

    return drag;
}

void ObjectIconView::dragEnterEvent( QDragEnterEvent *ev)
{
    ev->accept( FWObjectDrag::canDecode(ev) );
}

//void ObjectIconView::dropEvent(QDropEvent *ev)
//{
//    emit dropped(ev);
//}

void ObjectIconView::keyPressEvent( QKeyEvent* ev )
{
    if (ev->key()==Qt::Key_Delete)
    {
        emit delObject_sign();
    }
    QIconView::keyPressEvent(ev);
}


    
