/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: NetworkDialog.cpp,v 1.21 2006/05/13 06:53:05 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"

#include "FWBTree.h"
#include "NetworkDialog.h"
#include "ObjectManipulator.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/Network.h"
#include "fwbuilder/Interface.h"
#include "fwbuilder/FWException.h"

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <qpushbutton.h>

using namespace std;
using namespace libfwbuilder;

void NetworkDialog::loadFWObject(FWObject *o)
{
    obj=o;
    Network *s = dynamic_cast<Network*>(obj);
    assert(s!=NULL);

    init=true;

    fillLibraries(libs,obj);

    obj_name->setText( QString::fromUtf8(s->getName().c_str()) );
    address->setText( s->getAddress().toString().c_str() );
    netmask->setText( s->getNetmask().toString().c_str() );
    comment->setText( QString::fromUtf8(s->getComment().c_str()) );

    //apply->setEnabled( false );

    obj_name->setEnabled(!o->isReadOnly());
    setDisabledPalette(obj_name);

    libs->setEnabled(!o->isReadOnly());
    setDisabledPalette(libs);

    address->setEnabled(!o->isReadOnly());
    setDisabledPalette(address);

    netmask->setEnabled(!o->isReadOnly());
    setDisabledPalette(netmask);

    comment->setReadOnly(o->isReadOnly());
    setDisabledPalette(comment);


    init=false;
}
    
void NetworkDialog::changed()
{
    //apply->setEnabled( true );
    emit changed_sign();
}

void NetworkDialog::validate(bool *res)
{
    *res=true;
    Network *s = dynamic_cast<Network*>(obj);
    assert(s!=NULL);
    try
    {
        IPAddress( address->text().latin1() );
    } catch (FWException &ex)
    {
        *res=false;
        QMessageBox::critical(this, "Firewall Builder",
                              tr("Illegal IP address '%1'").arg(address->text()),
                              tr("&Continue"), 0, 0,
                              0 );
    }
    try
    {
        Netmask( netmask->text().latin1() );
    } catch (FWException &ex)
    {
        *res=false;
        QMessageBox::critical(this, "Firewall Builder",
                              tr("Illegal netmask '%1'").arg( netmask->text() ),
                              tr("&Continue"), 0, 0,
                              0 );
    }
}

void NetworkDialog::isChanged(bool *res)
{
    //*res=(!init && apply->isEnabled());
}

void NetworkDialog::libChanged()
{
    changed();
}

void NetworkDialog::applyChanges()
{
    if (!isTreeReadWrite(this,obj)) return;
    if (!validateName(this,obj,obj_name->text())) return;

    bool res=true;
    validate( &res );
    if (!res) return;

    Network *s = dynamic_cast<Network*>(obj);
    assert(s!=NULL);

    string oldname=obj->getName();
    obj->setName( string(obj_name->text().utf8()) );
    obj->setComment( string(comment->text().utf8()) );
    try 
    {
        s->setAddress( address->text().latin1() );
        s->setNetmask( netmask->text().latin1() );
    } catch (FWException &ex)
    {
/* exception thrown if user types illegal address or netmask */

    }
    om->updateObjName(obj,QString::fromUtf8(oldname.c_str()));

    init=true;

/* move to another lib if we have to */
    if (! FWBTree::isSystem(obj) && libs->currentText() != QString(obj->getLibrary()->getName().c_str()))
        om->moveObject(libs->currentText(), obj);

    init=false;
    //apply->setEnabled( false );
    om->updateLastModifiedTimestampForAllFirewalls(obj);
}

void NetworkDialog::discardChanges()
{
    loadFWObject(obj);
}


/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void NetworkDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

