/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Zaliva lord@crocodile.org

  $Id: FWObjectDatabase.hh,v 1.11 2002/08/29 00:34:09 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __FWOBJECTDATABASE_HH_FLAG__
#define __FWOBJECTDATABASE_HH_FLAG__

#include <fwbuilder/FWObject.hh>
#include <fwbuilder/FWException.hh>
#include <fwbuilder/ThreadTools.hh>
#include <fwbuilder/XMLTools.hh>

namespace libfwbuilder
{

    class Firewall;

/**
 * Database of objects.
 */
class FWObjectDatabase : public FWObject
{
    protected:

    static long               IDcounter     ;
//    static Mutex              IDmutex       ;
    static const std::string       DTD_FILE_NAME ;

    std::string data_file;

    Firewall* _findFirewallByNameRecursive(FWObject* db,const std::string &name) throw(FWException);

    public:

    DECLARE_FWOBJECT_SUBTYPE(FWObjectDatabase);

    /**
     * this constructor initializes singleton db
     */
    FWObjectDatabase();
    /**
     * this constructor makes a copy of entire tree and does not
     * intitialize db
     */
    FWObjectDatabase(FWObjectDatabase& d);

    virtual ~FWObjectDatabase() {};
    
    // --- XML import/export ---
    
    /**
     * This is the main "Create" method:
     * it creates instance of FWObject of given type
     *
     * if parameter 'create_with_root' is true, this method will create
     * objects using constructor that uses pointer to this as a parameter,
     * otherwise empty constructor is used
     */
    virtual FWObject *create(const std::string &type, bool create_with_root=false);

    /**
     * Creates instance of FWObject using its XML representation
     */
    virtual FWObject *createFromXML(xmlNodePtr data);

    virtual xmlNodePtr toXML(xmlNodePtr parent) throw(FWException);
    
    std::string generateUniqueId();
    
    // --- Load/Save ---
    
    virtual void saveFile       ( const std::string &filename) throw(FWException); 
    virtual void saveXML        ( xmlDocPtr             ) throw(FWException); 
    virtual void load           ( const std::string &filename, XMLTools::UpgradePredicate *upgrade) throw(FWException);

    Firewall* findFirewallByName(const std::string &name) throw(FWException);


    void setFileName (const std::string &filename);
    const std::string& getFileName ();
    const std::string  getFileDir ();

    // --- Standard object IDs ---

    static const std::string     getRootId()         { return "root";   }
    static const std::string     getAnyNetworkId()   { return "sysid0"; }
    static const std::string     getAnyIPServiceId() { return "sysid1"; }
    static const std::string     getAnyIntervalId()  { return "sysid2"; }
        

    // singelton

    static FWObjectDatabase  *db;

};

}

#endif

