/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Tools.hh,v 1.10 2002/08/29 00:34:09 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/*
 * This file contains various utility methods
 */

#ifndef __FW_TOOLS_HH_FLAG__
#define __FW_TOOLS_HH_FLAG__

#ifndef SAME
# define SAME 0
#endif

#ifndef nil
# define nil NULL
#endif

#include <string>
#include <map>

#include <fwbuilder/FWException.hh>

namespace libfwbuilder
{

    /**
     * This method should be called to initialize the library
     * before any calls to it are made.
     */
    void init();

    char *strtok_r(char *s, const char *delim, char **save_ptr);

    char *cxx_strdup(const char *x);
    char *cxx_strdup(const std::string &x);

    std::string int2string(int n);

    /**
     * Replace all occurences of ${MACRO} in the source string
     * with value from given map. If value not found, depending on
     * value of 'strict' flag eitehr exception is thrown or empty 
     * value is inserted.
     */
    std::string substituteMacros(const std::string &source, const std::map<std::string, std::string> &macros, bool strict=false) throw(libfwbuilder::FWException);

}

#endif


