/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Zaliva lord@crocodile.org

  $Id: manifest.cc,v 1.5 2002/08/29 00:34:09 vkurland Exp $

*/

#include "manifest.hh"

#include <fwbuilder/Tools.hh>

#include <functional>
#include <numeric>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

using namespace std;
using namespace fwcompiler;
using namespace libfwbuilder;

Action::operator string() const
{
    return action+" "+filename+" "+parameters;
}

Manifest::Manifest()
{
}

Manifest::Manifest(const string &s) throw(FWException)
{
    int  lineno=0;
    char *tok0;
    char *data, *data_copy = cxx_strdup(s);
    char *line;

    while((line=libfwbuilder::strtok_r(data, "\n", &tok0)) != NULL)
    {
        lineno++;
        if(data) 
            data=NULL;
        if(*data=='#') 
            continue; //comment

        Action a;

        char *tok1;
        char *x;

        x = libfwbuilder::strtok_r(line, "\t ", &tok1);
        if(!x)
        {
            delete data_copy;
            throw FWException("Missing action field in manifest file line "+int2string(lineno));
        } else
            a.action = x;

        x = libfwbuilder::strtok_r(NULL, "\t ", &tok1);
        if(!x)
        {
            delete data_copy;
            throw FWException("Missing filename field in manifest file line "+int2string(lineno));
        } else
            a.filename = x;

        x = libfwbuilder::strtok_r(NULL, "", &tok1);
        if(x)
            a.parameters = x;
        
        push_back(a);
    }

    delete data_copy;

}

Manifest::operator string() const
{
    string res="# FWBuilder Compiler Manifest File\n# http://www.fwbuilder.org/\n\n";
    for(const_iterator i=begin(); i!=end(); i++)
        res+=(string)(*i)+"\n";
    return res;
}

void Manifest::save(const string &filename, mode_t mode) const throw(FWException)
{
    int f = open(filename.c_str(), O_CREAT|O_EXCL|O_WRONLY, mode);
    if(f==-1)
        throw FWException("Error creating manifest file: "+filename);
    
    string data = (string)(*this);
    
    if(!data.empty())
    {
        if(::write(f, data.data(), data.length())!=data.length())
        {
            close(f);
            throw FWException("Error writing manifest file: "+filename);
        }
    }
    
    close(f);
}
