/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Zaliva lord@crocodile.org

  $Id: manifest.hh,v 1.8 2002/08/29 00:34:09 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef __MANIFEST_HH_FLAG__
#define __MANIFEST_HH_FLAG__

#include <fwbuilder/libfwbuilder-config.h>
#include <fwbuilder/FWException.hh>

#include <vector>

#ifdef __MINGW32__
# include <fcntl.h>
#endif

#include <sys/types.h>

namespace fwcompiler
{
    /**
     * Manifest file element
     */
    struct Action
    {
        std::string action     ;
        std::string filename   ;
        std::string parameters ;
        
        /**
         * Returns string representation of this action.
         */
        operator std::string() const;
    };
    
    /**
     * Compiler Manifest File
     *
     * @see doc/ManifestFile.txt
     */
    class Manifest: public std::vector<Action>
    {
        public:

        /**
         * Creates new empty Manifest
         */
        Manifest();

        /**
         * Parse string representation of manifest.
         * (used to parse manifest received over network connection)
         */
        Manifest(const std::string &) throw(libfwbuilder::FWException);

        /**
         * Returns string representation of this Manifest.
         * (used to send manifest over network connection)
         */
        operator std::string() const;

        /**
         * Convinience method: saves Manifest to file.
         * File must not exist, otherwise exception will be throws.
         *
         * @param filename file name
         * @param Unix file creation mask. See creat(2) for details.
         */
        void save(const std::string &filename, mode_t mode) const throw(libfwbuilder::FWException);

    };
}

#endif //__MANIFEST_HH_FLAG__
