
%define major   2
%define name    libfwbuilder
%define version 2.0.12
%define release 1

%if "%_vendor" == "MandrakeSoft"
%define libname  %name
%define libgroup System/Libraries
%define devgroup Development/Other
%else
%define libname  %name
%define libgroup System Environment/Libraries
%define devgroup Development/Libraries
%endif

Summary: 	Firewall Builder API
Name:           %{name}
Version:        %{version}
Release:        %{release}
License: 	GPL2
Group:  	%{libgroup}
Url: 		http://www.fwbuilder.org/
Source: 	http://prdownloads.sourceforge.net/libfwbuilder/%{name}-%{version}.tar.gz
Packager: 	Vadim Kurland <vadim@fwbuilder.org>

Buildroot:      %{_tmppath}/%{name}-%{version}-root

BuildRequires: libxml2-devel, libxslt-devel, openssl-devel

Docdir:   	/usr/share/doc

%description 
Firewall Builder 2.0 API library and compiler framework

%if "%{libname}" != "%{name}"
%package -n %libname
Summary: 	Firewall Builder 2.0 API
Provides: 	%name = %version
Group:  	%{libgroup}
%endif

%description -n %libname
Firewall Builder 2.0 API library and compiler framework

%files -n %libname
%defattr(-,root,root)
%doc doc/AUTHORS doc/COPYING doc/ChangeLog doc/Credits doc/INSTALL doc/PatchAcceptancePolicy.txt
%dir /usr/share/libfwbuilder
/usr/share/libfwbuilder/*
%_libdir/libfwbuilder.so.*
%_libdir/libfwcompiler.so.*




%package -n %{libname}-devel
Summary:   Firewall Builder API Libraries and Header Files
Group:     %{devgroup}
Requires:  %{name} = %{version}
Provides:  %name-devel = %version-%release

%description -n %{libname}-devel
This package contains the libraries  and header files that programmer would
need to develop applications using Firewall Builder API.


%files  -n %{libname}-devel
%defattr(-,root,root)
%doc doc/AUTHORS doc/COPYING doc/ChangeLog doc/Credits doc/INSTALL doc/README doc/PatchAcceptancePolicy.txt
/usr/bin/libfwbuilder-config-2
/usr/include/fwb-2.0/fwbuilder
/usr/include/fwb-2.0/fwcompiler
%_libdir/*.so

%prep 

%setup

%build
./configure --enable-auto-docdir --libdir=%{_libdir} --prefix=/usr/ 
make QTDIR=`cat qtdir` all

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make QTDIR=`cat qtdir` DDIR="${RPM_BUILD_ROOT}/" install
# prevent including docs twice
rm -fr $RPM_BUILD_ROOT/usr/share/doc/%{name}-%version

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT



