/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Group.cpp,v 1.3 2006/03/05 05:37:23 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream>

#include <fwbuilder/libfwbuilder-config.h>

#include <fwbuilder/FWObject.h>
#include <fwbuilder/FWObjectDatabase.h>
#include <fwbuilder/Group.h>
#include <fwbuilder/XMLTools.h>

using namespace libfwbuilder;
using namespace std;

const char *Group::TYPENAME={"Group"};

/*
 *  Group should inherit a list of allowed types from its parent upon creation
 */
Group::Group()  {}
Group::Group(const FWObject *root) : FWObject(root)
{
    setRoot(root);   // do not remove!
}

Group::~Group() 
{
}

bool  Group::validateChild(FWObject *o)
{ 
    return FWObject::validateChild(o);
}

int Group::getSize()
{
    return getChildrenCount();
}






