
%define major   2
%define name    libfwbuilder
%define version 2.1.9
%define release 1
%define BUILD_VERSION 21

%if "%_vendor" == "MandrakeSoft"
%define libname  %name
%define libgroup System/Libraries
%define devgroup Development/Other
%else
%define libname  %name
%define libgroup System Environment/Libraries
%define devgroup Development/Libraries
%endif

Summary: 	Firewall Builder API
Name:           %{name}
Version:        %{version}
Release:        %{release}
License: 	GPL2
Group:  	%{libgroup}
Url: 		http://www.fwbuilder.org/
Source: 	http://prdownloads.sourceforge.net/libfwbuilder/%{name}-%{version}.tar.gz
Packager: 	Vadim Kurland <vadim@fwbuilder.org>

Buildroot:      %{_tmppath}/%{name}-%{version}-root

BuildRequires: libxml2-devel, libxslt-devel, openssl-devel
%if "%_vendor" == "redhat"
BuildRequires: qt-devel
%else
BuildRequires: qt3-devel
%endif

Docdir:   	/usr/share/doc

%description 
Firewall Builder 2.1 API library and compiler framework

%if "%{libname}" != "%{name}"
%package -n %libname
Summary: 	Firewall Builder 2.1 API
Provides: 	%name = %version
Group:  	%{libgroup}
%endif

%description -n %libname
Firewall Builder 2.1 API library and compiler framework

%files -n %libname
%defattr(-,root,root)
%doc doc/AUTHORS doc/COPYING doc/ChangeLog doc/Credits doc/INSTALL doc/PatchAcceptancePolicy.txt
%dir /usr/share/libfwbuilder%{BUILD_VERSION}
/usr/share/libfwbuilder%{BUILD_VERSION}/*
%_libdir/libfwbuilder.so.*
%_libdir/libfwcompiler.so.*




%package -n %{libname}-devel
Summary:   Firewall Builder API Libraries and Header Files
Group:     %{devgroup}
Requires:  %{name} = %{version}
Provides:  %name-devel = %version-%release

%description -n %{libname}-devel
This package contains the libraries  and header files that programmer would
need to develop applications using Firewall Builder API.


%files  -n %{libname}-devel
%defattr(-,root,root)
%doc doc/AUTHORS doc/COPYING doc/ChangeLog doc/Credits doc/INSTALL doc/README doc/PatchAcceptancePolicy.txt
/usr/bin/libfwbuilder-config-2.1
/usr/include/fwb-2.1/fwbuilder
/usr/include/fwb-2.1/fwcompiler
%_libdir/*.so

%prep 

%setup

%build
[ -n "$QTDIR" ] || {
  [ -f %{_sysconfdir}/profile.d/qt.sh ] && . %{_sysconfdir}/profile.d/qt.sh
  [ -f %{_sysconfdir}/profile.d/qtdir3.sh ] && . %{_sysconfdir}/profile.d/qtdir3.sh
  [ -f %{_sysconfdir}/SuSEconfig/profile ] && . %{_sysconfdir}/SuSEconfig/profile
}
%configure --enable-auto-docdir --libdir=%{_libdir} --prefix=/usr/ 
make all

%install
[ -n "$QTDIR" ] || {
  [ -f %{_sysconfdir}/profile.d/qt.sh ] && . %{_sysconfdir}/profile.d/qt.sh
  [ -f %{_sysconfdir}/profile.d/qtdir3.sh ] && . %{_sysconfdir}/profile.d/qtdir3.sh
  [ -f %{_sysconfdir}/SuSEconfig/profile ] && . %{_sysconfdir}/SuSEconfig/profile
}
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make DDIR="${RPM_BUILD_ROOT}/" install
# prevent including docs twice
rm -rf $RPM_BUILD_ROOT/%{_datadir}/doc/%{name}-%{version}

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

