/* Connection.java */

/* 
 * Copyright (C) 1996 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

/**
 * @author Mark Boyns
 */
public class Connection
{
    protected DataInputStream in;
    protected DataOutputStream out;
    protected Socket socket;
    
    Connection (Socket socket) throws IOException
    {
	this.socket = socket;
	
	in = new DataInputStream (new BufferedInputStream (socket.getInputStream ()));
	out = new DataOutputStream (new BufferedOutputStream (socket.getOutputStream ()));
    }
    
    Connection (String host, int port) throws IOException
    {
	socket = new Socket (host, port);
	in = new DataInputStream (new BufferedInputStream (socket.getInputStream ()));
	out = new DataOutputStream (new BufferedOutputStream (socket.getOutputStream ()));
    }

    public DataInputStream getInputStream ()
    {
	return in;
    }
    
    public DataOutputStream getOutputStream ()
    {
	return out;
    }

    public void close ()
    {
	try
	{
	    socket.close ();
	}
	catch (Exception e)
	{
	    System.out.println ("Connection: " + e);
	}
    }
}
