/* Filters.java */

/* 
 * Copyright (C) 1996 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.Vector;

/**
 * @author Mark Boyns
 */
public class Filters extends Frame
{
    Vector knownFilters = null;
    Vector runningFilters = null;
    
    BigList knownFiltersList = null;
    BigList runningFiltersList = null;
    
    public Filters ()
    {
	super ("Filters");

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));
	
	knownFilters = new Vector (100);
	runningFilters = new Vector (100);

	knownFilters.addElement ("muffin.filters.CookieMonster");
	knownFilters.addElement ("muffin.filters.Logger");
	knownFilters.addElement ("muffin.filters.SecretAgent");
	knownFilters.addElement ("muffin.filters.SecretServer");
	knownFilters.addElement ("muffin.filters.Snoop");
	knownFilters.addElement ("muffin.filters.Stats");
	
	knownFiltersList = new BigList (10, false);
	runningFiltersList = new BigList (10, false);

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
	panel.setLayout (layout);

	Label l;
	Button b;
	GridBagConstraints c;
	Panel p;
	
	l = new Label ("Known Filters");
	l.setFont (new Font ("Fixed", Font.BOLD, 12));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);

	c = new GridBagConstraints ();
	c.gridheight = 2;
	c.insets = new Insets (0, 10, 5, 10);
	layout.setConstraints (knownFiltersList, c);
	panel.add (knownFiltersList);

	b = new Button ("Run");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);
	
	b = new Button ("New...");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);
	
	l = new Label ("Running Filters");
	l.setFont (new Font ("Fixed", Font.BOLD, 12));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);

	c = new GridBagConstraints ();
	c.gridheight = 4;
	c.insets = new Insets (0, 10, 5, 10);
	layout.setConstraints (runningFiltersList, c);
	panel.add (runningFiltersList);

	b = new Button ("View...");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);
	
	b = new Button ("Move Up");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);

	b = new Button ("Move Down");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);

	b = new Button ("Stop");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);

	add ("Center", panel);
	
	Panel buttonPanel = new Panel ();
	buttonPanel.add (new Button ("Done"));
	add ("South", buttonPanel);
	
	pack ();
	resize (preferredSize ());
	//resize (300, 500);

	updateKnownFiltersList ();
    }

    void updateKnownFiltersList ()
    {
	knownFiltersList.clear ();
	Enumeration e = knownFilters.elements ();
 	while (e.hasMoreElements ())
 	{
	    String s = (String) e.nextElement ();
	    knownFiltersList.addItem (s);
	}
    }	

    void updateRunningFiltersList ()
    {
	runningFiltersList.clear ();
	Enumeration e = runningFilters.elements ();
 	while (e.hasMoreElements ())
 	{
	    Filter f = (Filter) e.nextElement ();
	    runningFiltersList.addItem ((f.getClass ()).getName ());
	}
    }
    
    void filterRequest (Request r)
    {
	Enumeration e = runningFilters.elements ();
 	while (e.hasMoreElements ())
 	{
	    Filter f = (Filter) e.nextElement ();
	    f.filterRequest (r);
	}
    }

    void filterReply (Reply r)
    {
	Enumeration e = runningFilters.elements ();
 	while (e.hasMoreElements ())
 	{
	    Filter f = (Filter) e.nextElement ();
	    f.filterReply (r);
	}
    }

    public void hideshow ()
    {
	if (isShowing ())
	{
	    hide ();
	}
	else
	{
	    show ();
	}
    }

    void doit (String file)
    {
	int i = file.lastIndexOf (".");
        file = file.substring (0, i);
        
        try
        {
            System.out.println ("loading " + file + "...");
            Class c = Class.forName (file);
            System.out.println ("loading " + file + "...done");
            Frame f = new Frame (file);
            Object o = c.newInstance ();
/*	    
            Applet a = (Applet) o;
            a.init ();
            a.start ();
            f.show ();
	    */	    
        }
        catch (Exception e)
        {
            System.out.println (e);
        }
    }

    void run (String clazz)
    {
	try
	{
	    Filter f = (Filter) (Class.forName (clazz)).newInstance ();
	    runningFilters.addElement (f);
	    updateRunningFiltersList ();
	}
	catch (Exception e)
	{
	    System.out.println (e);
	}
    }

    void view (String clazz)
    {
	Enumeration e = runningFilters.elements ();
	while (e.hasMoreElements ())
	{
	    Filter f = (Filter) e.nextElement ();
	    if (clazz.equals ((f.getClass ()).getName ()))
	    {
		f.view ();
	    }
	}
    }

    public boolean action (Event event, Object arg)
    {
	if (event.target == knownFiltersList)
	{
	    run ((String)arg);
	}
	else if (event.target == runningFiltersList)
	{
	    view ((String)arg);
	}
	else if (event.target instanceof Button)
	{
	    if ("Done".equals (arg))
	    {
		hide ();
	    }
	    else if ("Run".equals (arg))
	    {
		int i = knownFiltersList.getSelectedIndex ();
		if (i != -1)
		{
		    run (knownFiltersList.getItem (i));
		}
	    }
	    else if ("New...".equals (arg))
	    {
	    }
	    else if ("View...".equals (arg))
	    {
		int i = runningFiltersList.getSelectedIndex ();
		if (i != -1)
		{
		    view (runningFiltersList.getItem (i));
		}
	    }
	    else if ("Move Up".equals (arg))
	    {
		int i = runningFiltersList.getSelectedIndex ();
		if (i > 0)
		{
		    Object prev = runningFilters.elementAt (i-1);
		    Object curr = runningFilters.elementAt (i);
		    runningFilters.setElementAt (curr, i-1);
		    runningFilters.setElementAt (prev, i);
		    updateRunningFiltersList ();
		    runningFiltersList.select (i-1);
		}
	    }
	    else if ("Move Down".equals (arg))
	    {
		int i = runningFiltersList.getSelectedIndex ();
		if (i < runningFilters.size () - 1)
		{
		    Object next = runningFilters.elementAt (i+1);
		    Object curr = runningFilters.elementAt (i);
		    runningFilters.setElementAt (curr, i+1);
		    runningFilters.setElementAt (next, i);
		    updateRunningFiltersList ();
		    runningFiltersList.select (i+1);
		}
	    }
	    else if ("Stop".equals (arg))
	    {
		int i = runningFiltersList.getSelectedIndex ();
		if (i != -1)
		{
		    runningFilters.removeElementAt (i);
		    updateRunningFiltersList ();
		}
	    }
	    return true;
	}
	return false;
    }
}    
