/* Message.java */

/* 
 * Copyright (C) 1996 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.util.Hashtable;
import java.util.Enumeration;
import java.io.DataInputStream;
import java.io.IOException;

/**
 * @author Mark Boyns
 */
public abstract class Message
{
    protected Hashtable headers = new Hashtable (32);
    protected String headline = null;

    protected void readHeaders (DataInputStream in) throws IOException
    {
	int i;
	
	for (;;)
	{
	    String s = in.readLine ();
	    if (s == null)
	    {
		break;
	    }
	    i = s.indexOf (':');
	    if (i == -1)
	    {
		break;
	    }
	    headers.put (new Key (s.substring (0, i)),
		       s.substring (i+2));
	}	
    }
    
    public Hashtable getHeaders ()
    {
	return headers;
    }

    public String getHeaderField (String name)
    {
	return (String) headers.get (new Key (name));
    }

    public void setHeaderField (String name, String value)
    {
	headers.put (new Key (name), value);
    }

    public void removeHeaderField (String name)
    {
	headers.remove (new Key (name));
    }

    public boolean containsHeaderField (String name)
    {
	return headers.containsKey (new Key (name));
    }
    
    public String toString ()
    {
	StringBuffer buf = new StringBuffer ();
	Key key;
	String value;

	buf.append (headline);
	buf.append ("\r\n");
	
	for (Enumeration e = headers.keys (); e.hasMoreElements (); )
	{
	    key = (Key) e.nextElement ();
	    value = (String) headers.get (key);
	    buf.append (key + ": " + value + "\r\n");
	}
	buf.append ("\r\n");

	return buf.toString ();
    }
}
