/* CookieMonster.java */

/* 
 * Copyright (C) 1996 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import java.awt.*;
import muffin.*;

public class CookieMonster extends Frame implements Filter
{
    boolean eatRequestCookies = true;
    boolean eatReplyCookies = true;
    Checkbox eatReply, eatRequest;
    int eatenRequestCookies = 0;
    int eatenReplyCookies = 0;
    TextArea text;
    
    public CookieMonster ()
    {
	super ("Cookie Monster");

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
	panel.setLayout (layout);
	GridBagConstraints c;

	eatRequest = new Checkbox ("Eat Request Cookies");
	eatRequest.setState (eatRequestCookies);
	eatReply = new Checkbox ("Eat Reply Cookies");
	eatReply.setState (eatReplyCookies);
	
	c = new GridBagConstraints ();
	layout.setConstraints (eatRequest, c);
	panel.add (eatRequest);
	
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (eatReply, c);
	panel.add (eatReply);
	
	text = new TextArea ();
	text.setEditable (false);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (text, c);
	panel.add (text);
	
	add ("Center", panel);

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 3));
	buttonPanel.add (new Button ("Apply"));
	buttonPanel.add (new Button ("Clear"));
	buttonPanel.add (new Button ("Close"));
	add ("South", buttonPanel);
	
	pack ();
	resize (preferredSize ());
    }
    
    public void filterRequest (Request r)
    {
	if (eatRequestCookies && r.containsHeaderField ("Cookie"))
	{
	    text.appendText ("Cookie: " + r.getHeaderField ("Cookie") + "\n");
	    r.removeHeaderField ("Cookie");
	    eatenRequestCookies++;
	}
    }
    
    public void filterReply (Reply r)
    {
	if (eatReplyCookies && r.containsHeaderField ("Set-Cookie"))
	{
	    text.appendText ("Set-Cookie: " + r.getHeaderField ("Set-Cookie") + "\n");
	    r.removeHeaderField ("Set-Cookie");
	    eatenReplyCookies++;
	}
    }

    public void view ()
    {
	show ();
    }

    public boolean action (Event e, Object arg)
    {
	if (e.target instanceof Button)
	{
	    if ("Apply".equals (arg))
	    {
		eatReplyCookies = eatReply.getState ();
		eatRequestCookies = eatRequest.getState ();
	    }
	    else if ("Close".equals (arg))
	    {
		hide ();
	    }
	    else if ("Clear".equals (arg))
	    {
		text.setText ("");
	    }
	    return true;
	}
	return false;
    }
}
