/* SecretAgent.java */

/* 
 * Copyright (C) 1996 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import java.awt.*;
import muffin.*;

public class SecretAgent extends Frame implements Filter
{
    String agent = null;
    String realAgent = "";
    TextField input = null;

    public SecretAgent ()
    {
	super ("Secret Agent");

	String sampleAgents[] =
	{
	    "Secret/1.0",
	    "aolbrowser 1.1 Macintosh; 68K",
	    "ArchitextSpider",
	    "Java1.0.2",
	    "Lynx 2.5  libwww-FM/2.14",
	    "Lynx/2.6  libwww-FM/2.14",
	    "MacWeb/1.00ALPHA3.2  libwww/2.17",
	    "Microsoft Internet Explorer/4.40.425 (Windows 95)",
	    "MOMspider/1.00 libwww-perl/0.40",
	    "Mozilla/0.9 Beta (Windows)",
	    "Mozilla/1.0 (Windows)",
	    "Mozilla/1.0N (Macintosh)",
	    "Mozilla/1.1 (Windows; I; 16bit)",
	    "Mozilla/1.1N (Macintosh; I; PPC)",
	    "Mozilla/1.2 (Windows; U; 16bit)",
	    "Mozilla/1.22 (compatible; MSIE 1.5; Windows 95)",
	    "Mozilla/1.22 (compatible; MSIE 2.0; Windows 95)",
	    "Mozilla/2.0 (X11; U; SunOS 5.4 sun4m)",
	    "Mozilla/2.0 (compatible; MSIE 2.0; Mac_PowerPC)",
	    "Mozilla/2.01 (WinNT; U)",
	    "Mozilla/2.01Gold (Win95; I)",
	    "Mozilla/2.02 (Macintosh; I; PPC)",
	    "Mozilla/3.0 (Win95; I)",
	    "Mozilla/3.0Gold (X11; U; Linux 2.0.22 i586)",
	    "NCSA Mosaic for the X Window System/2.0",
	    "NCSA Mosaic/2.0 (Windows x86)",
	    "NCSA_Mosaic/2.6-1 (X11;OpenVMS Unknown VAX_ALPHA)",
	    "NCSA_Mosaic/2.7b5 (X11;SunOS 5.5 sun4m)",
	    "PRODIGY-WB 3.1d",
	};
	
	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
	GridBagConstraints c;
        panel.setLayout (layout);

	panel.add (new Label ("User-Agent:", Label.RIGHT));

	input = new TextField (32);
	c = new GridBagConstraints ();
	c.anchor = GridBagConstraints.WEST;
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (input, c);
	panel.add (input);

	panel.add (new Label ("Sample Agents:", Label.RIGHT));

	Choice choice = new Choice ();
	for (int i = 0; i < sampleAgents.length; i++)
	{
	    choice.addItem (sampleAgents[i]);
	}
	
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (choice, c);
	panel.add (choice);
	
	add ("Center", panel);

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 3));
	buttonPanel.add (new Button ("Apply"));
	buttonPanel.add (new Button ("Default"));
	buttonPanel.add (new Button ("Close"));
	add ("South", buttonPanel);

	pack ();
	resize (preferredSize ());
    }
    
    public void filterRequest (Request r)
    {
	if (agent == null)
	{
	    /* use the first User-Agent as the "real" agent */
	    realAgent = r.getHeaderField ("User-Agent");
	    input.setText (realAgent);
	}
	else
	{
	    r.setHeaderField ("User-Agent", agent);
	}
    }
    
    public void filterReply (Reply r)
    {
    }

    public void view ()
    {
	show ();
    }

    public boolean action (Event e, Object arg)
    {
	if (e.target instanceof Button)
	{
	    if ("Apply".equals (arg))
	    {
		String s = input.getText ();
		if (s != null && s.length () > 0)
		{
		    agent = s;
		}
		else
		{
		    agent = null;
		}
	    }
	    else if ("Default".equals (arg))
	    {
		input.setText (realAgent);
	    }
	    else if ("Close".equals (arg))
	    {
		hide ();
	    }
	    return true;
	}
	else if (e.target instanceof Choice)
	{
	    input.setText ((String)arg);
	}
	return false;
    }
}
