/* Stats.java */

/* 
 * Copyright (C) 1996 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import java.awt.*;
import java.util.*;
import muffin.*;

public class Stats extends Frame implements Filter
{
    TextArea text;
    int requests;
    int replies;
    Hashtable hosts;
    Hashtable servers;
    Hashtable contentLengths;
    Hashtable contentTypes;

    public Stats ()
    {
	super ("Stats");

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	text = new TextArea ();
	text.setEditable (false);
	add ("Center", text);

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 3));
	buttonPanel.add (new Button ("Update"));
	buttonPanel.add (new Button ("Reset"));
	buttonPanel.add (new Button ("Close"));
	add ("South", buttonPanel);

	resize (300, 400);

	reset ();
    }

    public void filterRequest (Request r)
    {
	String str;
	
	requests++;

	str = r.getHost ();
	increment (hosts, str != null ? str : "null", 1);
    }
    
    public void filterReply (Reply r)
    {
	String str;
	
	replies++;

	str = r.getHeaderField ("Content-type");
	increment (contentTypes, str != null ? str : "null", 1);

	if (str != null)
	{
	    try 
	    {
		int length = Integer.parseInt (r.getHeaderField ("Content-length"));
		increment (contentLengths, str, length);
	    }
	    catch (Exception e)
	    {
	    }
	}
	

	str = r.getHeaderField ("Server");
	increment (servers, str != null ? str : "null", 1);
    }

    public void view ()
    {
	show ();
    }

    void reset ()
    {
	text.setText ("");
	requests = 0;
	replies = 0;
	hosts = new Hashtable (100);
	servers = new Hashtable (100);
	contentTypes = new Hashtable (100);
	contentLengths = new Hashtable (100);
    }
    
    void increment (Hashtable h, String key, int value)
    {
	Integer count = (Integer) h.get (key);
	if (count == null)
	{
	    count = new Integer (0);
	}
	count = new Integer (count.intValue () + value);
	h.put (key, count);
    }

    void print (Hashtable h)
    {
	String key;
	Integer count;
	int total = 0;

	for (Enumeration e = h.keys (); e.hasMoreElements (); )
	{
	    key = (String) e.nextElement ();
	    count = (Integer) h.get (key);
	    text.appendText ("    " + key + ": " + count + "\n");
	    total += count.intValue ();
	}
	text.appendText ("    TOTAL: " + total + "\n");
    }

    void update ()
    {
	String key;
	Integer count;

	text.setText ("");

	text.appendText ((new Date ()).toString ());
	text.appendText ("\n");
	
	text.appendText ("Requests: ");
	text.appendText (requests + "\n");
	
	text.appendText ("Replies: ");
	text.appendText (replies + "\n");
	
	text.appendText ("Hosts:\n");
	print (hosts);
	
	text.appendText ("Servers:\n");
	print (servers);
	
	text.appendText ("Content-types:\n");
	print (contentTypes);

	text.appendText ("Content-lengths:\n");
	print (contentLengths);
    }

    public boolean action (Event e, Object arg)
    {
	if (e.target instanceof Button)
	{
	    if ("Reset".equals (arg))
	    {
		reset ();
	    }
	    else if ("Close".equals (arg))
	    {
		hide ();
	    }
	    else if ("Update".equals (arg))
	    {
		update ();
	    }
	    return true;
	}
	return false;
    }
}
