/* Filters.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.Vector;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

/**
 * @author Mark Boyns
 */
public class Filters extends Frame
{
    Vector knownFilters = null;
    Vector enabledFilters = null;
    
    BigList knownFiltersList = null;
    BigList enabledFiltersList = null;
    
    public Filters ()
    {
	super ("Filters");

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));
	
	knownFilters = new Vector (100);
	enabledFilters = new Vector (100);

	knownFilters.addElement ("muffin.filters.CookieMonster");
	knownFilters.addElement ("muffin.filters.Logger");
	knownFilters.addElement ("muffin.filters.Referer");
	knownFilters.addElement ("muffin.filters.SecretAgent");
	knownFilters.addElement ("muffin.filters.SecretServer");
	knownFilters.addElement ("muffin.filters.Stats");
 	knownFilters.addElement ("muffin.filters.Snoop");
	
	knownFiltersList = new BigList (10, false);
	enabledFiltersList = new BigList (10, false);

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
	panel.setLayout (layout);

	Label l;
	Button b;
	GridBagConstraints c;
	Panel p;
	
	l = new Label ("Known Filters");
	l.setFont (new Font ("Fixed", Font.BOLD, 12));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);

	c = new GridBagConstraints ();
	c.gridheight = 2;
	c.insets = new Insets (0, 10, 5, 10);
	layout.setConstraints (knownFiltersList, c);
	panel.add (knownFiltersList);

	b = new Button ("Enable");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);
	
	b = new Button ("New...");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);
	
	l = new Label ("Enabled Filters");
	l.setFont (new Font ("Fixed", Font.BOLD, 12));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);

	c = new GridBagConstraints ();
	c.gridheight = 4;
	c.insets = new Insets (0, 10, 5, 10);
	layout.setConstraints (enabledFiltersList, c);
	panel.add (enabledFiltersList);

	b = new Button ("View...");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);
	
	b = new Button ("Move Up");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);

	b = new Button ("Move Down");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);

	b = new Button ("Disable");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);

	add ("Center", panel);
	
	Panel buttonPanel = new Panel ();
	buttonPanel.add (new Button ("Done"));
	add ("South", buttonPanel);
	
	pack ();
	resize (preferredSize ());

	updateKnownFiltersList ();
    }

    void updateKnownFiltersList ()
    {
	knownFiltersList.clear ();
	Enumeration e = knownFilters.elements ();
 	while (e.hasMoreElements ())
 	{
	    String s = (String) e.nextElement ();
	    knownFiltersList.addItem (s);
	}
    }	

    void updateEnabledFiltersList ()
    {
	enabledFiltersList.clear ();
	Enumeration e = enabledFilters.elements ();
 	while (e.hasMoreElements ())
 	{
	    Filter f = (Filter) e.nextElement ();
	    enabledFiltersList.addItem ((f.getClass ()).getName ());
	}
    }
    
    void filter (Request r)
    {
	Enumeration e = enabledFilters.elements ();
 	while (e.hasMoreElements ())
 	{
	    Filter f = (Filter) e.nextElement ();
	    if (f instanceof RequestFilter)
	    {
		RequestFilter rf = (RequestFilter) f;
		rf.filter (r);
	    }
	}
    }

    void filter (Reply r)
    {
	Enumeration e = enabledFilters.elements ();
 	while (e.hasMoreElements ())
 	{
	    Filter f = (Filter) e.nextElement ();
	    if (f instanceof ReplyFilter)
	    {
		ReplyFilter rf = (ReplyFilter) f;
		rf.filter (r);
	    }
	}
    }

    public void hideshow ()
    {
	if (isShowing ())
	{
	    hide ();
	}
	else
	{
	    show ();
	}
    }

    void enable (String clazz)
    {
	try
	{
	    Filter f = (Filter) (Class.forName (clazz)).newInstance ();
	    enabledFilters.addElement (f);
	    updateEnabledFiltersList ();
	}
	catch (Exception e)
	{
	    System.out.println (e);
	}
    }

    void view (String clazz)
    {
	Enumeration e = enabledFilters.elements ();
	while (e.hasMoreElements ())
	{
	    Filter f = (Filter) e.nextElement ();
	    if (clazz.equals ((f.getClass ()).getName ()))
	    {
		f.view ();
	    }
	}
    }

    public boolean action (Event event, Object arg)
    {
	if (event.target == knownFiltersList)
	{
	    enable ((String)arg);
	}
	else if (event.target == enabledFiltersList)
	{
	    view ((String)arg);
	}
	else if (event.target instanceof Button)
	{
	    if ("Done".equals (arg))
	    {
		hide ();
	    }
	    else if ("Enable".equals (arg))
	    {
		int i = knownFiltersList.getSelectedIndex ();
		if (i != -1)
		{
		    enable (knownFiltersList.getItem (i));
		}
	    }
	    else if ("New...".equals (arg))
	    {
	    }
	    else if ("View...".equals (arg))
	    {
		int i = enabledFiltersList.getSelectedIndex ();
		if (i != -1)
		{
		    view (enabledFiltersList.getItem (i));
		}
	    }
	    else if ("Move Up".equals (arg))
	    {
		int i = enabledFiltersList.getSelectedIndex ();
		if (i > 0)
		{
		    Object prev = enabledFilters.elementAt (i-1);
		    Object curr = enabledFilters.elementAt (i);
		    enabledFilters.setElementAt (curr, i-1);
		    enabledFilters.setElementAt (prev, i);
		    updateEnabledFiltersList ();
		    enabledFiltersList.select (i-1);
		}
	    }
	    else if ("Move Down".equals (arg))
	    {
		int i = enabledFiltersList.getSelectedIndex ();
		if (i < enabledFilters.size () - 1)
		{
		    Object next = enabledFilters.elementAt (i+1);
		    Object curr = enabledFilters.elementAt (i);
		    enabledFilters.setElementAt (curr, i+1);
		    enabledFilters.setElementAt (next, i);
		    updateEnabledFiltersList ();
		    enabledFiltersList.select (i+1);
		}
	    }
	    else if ("Disable".equals (arg))
	    {
		int i = enabledFiltersList.getSelectedIndex ();
		if (i != -1)
		{
		    enabledFilters.removeElementAt (i);
		    updateEnabledFiltersList ();
		}
	    }
	    return true;
	}
	return false;
    }
}    
