/* Server.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.net.InetAddress;
import java.net.Socket;
import java.net.ServerSocket;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;

/**
 * @author Mark Boyns
 */
public class Server
{
    ServerSocket server = null;
    ThreadGroup handlers = null;
    Monitor monitor = null;
    Filters filters = null;
    Options options = null;
    boolean running = false;

    public Server (int port, Monitor m, Filters filters, Options options)
    {
	try
	{
	    server = new ServerSocket (port, 512);
	}
	catch (Exception e)
	{
	    System.out.println (e);
	    System.exit (0);
	}
	handlers = new ThreadGroup ("Handlers");
	monitor = m;
	this.filters = filters;
	this.options = options;
    }

    public void suspend ()
    {
	running = false;
    }

    public void resume ()
    {
	running = true;
    }

    public synchronized void stop ()
    {
	int n = handlers.activeCount ();
	if (n < 0)
	{
	    return;
	}
	Thread list[] = new Thread[n];
	handlers.enumerate (list);
	for (int i = 0; i < n; i++)
	{
	    Handler h = (Handler) list[i];
	    h.close ();
	}
    }
    
    public void run ()
    {

	running = true;
	for (;;)
	{
	    Socket socket;

	    try
	    {
		socket = server.accept ();
	    }
	    catch (Exception e)
	    {
		System.out.println (e);
		continue;
	    }

	    if (!options.hostAccess (socket.getInetAddress ()))
	    {
		System.out.println (socket.getInetAddress () + ": access denied");
		httpForbidden (socket);
		continue;
	    }

	    if (running)
	    {
		Handler h = new Handler (handlers, Thread.currentThread (), monitor, filters, options);
		h.doit (socket);
	    }
	    else
	    {
		httpServiceUnavailable (socket);
	    }
	}
    }

    void httpServiceUnavailable (Socket socket)
    {
	try
	{
	    DataOutputStream out = new DataOutputStream (new BufferedOutputStream (socket.getOutputStream ()));
	    out.writeBytes ("HTTP/1.0 503 Service Unavailable\r\n"
			    + "Content-type: text/html\r\n"
			    + "\r\n"
			    + "<head><title>Server Unavailable</title></head>\r\n"
			    + "<body><h1>Service Unavailable</h1>\r\n"
			    + "Muffin proxy service is suspended.<p>\r\n"
			    + "</body>\r\n");
	    out.flush ();
	    socket.close ();
	}
	catch (Exception e)
	{
	}
    }

    void httpForbidden (Socket socket)
    {
	try
	{
	    DataOutputStream out = new DataOutputStream (new BufferedOutputStream (socket.getOutputStream ()));
	    out.writeBytes ("HTTP/1.0 403 Forbidden\r\n"
			    + "Content-type: text/html\r\n"
			    + "\r\n"
			    + "<head><title>Forbidden: Access Denied</title></head>\r\n"
			    + "<body><h1>Forbidden: Access Denied</h1>\r\n"
			    + "No muffins for you!<p>\r\n"
			    + "</body>\r\n");
	    out.flush ();
	    socket.close ();
	}
	catch (Exception e)
	{
	}
    }
}
