/* SecretServer.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import java.awt.*;
import muffin.*;

public class SecretServer extends Frame implements ReplyFilter
{
    String server = null;
    TextField input = null;

    public SecretServer ()
    {
	super ("Secret Server");

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));
	
	input = new TextField (32);

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
        panel.setLayout (layout);

	panel.add (new Label ("Server:", Label.RIGHT));
	panel.add (input);
	add ("Center", panel);

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 2));
	buttonPanel.add (new Button ("Apply"));
	buttonPanel.add (new Button ("Close"));
	add ("South", buttonPanel);
	
	pack ();
	resize (preferredSize ());
    }
    
    public void filter (Reply r)
    {
	if (server != null)
	{
	    r.setHeaderField ("Server", server);
	}
    }

    public void view ()
    {
	show ();
    }

    public boolean action (Event e, Object arg)
    {
	if (e.target instanceof Button)
	{
	    if ("Apply".equals (arg))
	    {
		String s = input.getText ();
		if (s != null && s.length () > 0)
		{
		    server = s;
		}
		else
		{
		    server = null;
		}
	    }
	    else if ("Close".equals (arg))
	    {
		hide ();
	    }
	    return true;
	}
	return false;
    }
}
