/* Snoop.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import java.awt.*;
import muffin.*;

public class Snoop extends Frame implements RequestFilter, ReplyFilter
{
    TextArea text;
    
    public Snoop ()
    {
	super ("Snoop");

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	text = new TextArea ();
	text.setEditable (false);
	add ("Center", text);

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 2));
	buttonPanel.add (new Button ("Clear"));
	buttonPanel.add (new Button ("Close"));
	add ("South", buttonPanel);
	
	resize (600, 300);
    }
    
    public void filter (Request r)
    {
	text.appendText (r.toString ());
    }
    
    public void filter (Reply r)
    {
	text.appendText (r.toString ());
    }

    public void view ()
    {
	show ();
    }

    public boolean action (Event e, Object arg)
    {
	if (e.target instanceof Button)
	{
	    if ("Clear".equals (arg))
	    {
		text.setText ("");
	    }
	    else if ("Close".equals (arg))
	    {
		hide ();
	    }
	    return true;
	}
	return false;
    }
}
