/* Connection.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;

/**
 * @author Mark Boyns
 */
class Connection
{
    protected BufferedReader in;
    protected BufferedWriter out;
    protected Socket socket;
    
    Connection (Socket socket) throws IOException
    {
	this.socket = socket;
	in = new BufferedReader (new InputStreamReader (socket.getInputStream ()));
	out = new BufferedWriter (new OutputStreamWriter (socket.getOutputStream ()));
    }
    
    Connection (String host, int port) throws IOException
    {
	socket = new Socket (host, port);
	in = new BufferedReader (new InputStreamReader (socket.getInputStream ()));
	out = new BufferedWriter (new OutputStreamWriter (socket.getOutputStream ()));
    }

    public BufferedReader getReader ()
    {
	return in;
    }
    
    public BufferedWriter getWriter ()
    {
	return out;
    }

    public void close ()
    {
	try
	{
	    socket.close ();
	}
	catch (Exception e)
	{
	    System.out.println ("Connection: " + e);
	}
    }
}
