/* FilterManager.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.util.Vector;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

/**
 * @author Mark Boyns
 */
public class FilterManager
{
    Vector knownFilters = null;
    Vector enabledFilters = null;
    UserPrefs userPrefs;
    
    public FilterManager (UserPrefs userPrefs)
    {
	this.userPrefs = userPrefs;
	
	knownFilters = new Vector (32);
	enabledFilters = new Vector (32);

	knownFilters.addElement ("muffin.filters.AnimationKiller");
	knownFilters.addElement ("muffin.filters.CookieMonster");
	knownFilters.addElement ("muffin.filters.Logger");
	knownFilters.addElement ("muffin.filters.Referer");
	knownFilters.addElement ("muffin.filters.SecretAgent");
	knownFilters.addElement ("muffin.filters.SecretServer");
	knownFilters.addElement ("muffin.filters.Snoop");
	knownFilters.addElement ("muffin.filters.Stats");
	knownFilters.addElement ("muffin.filters.Test");

	String list[] = userPrefs.getStringList ("muffin.enabledFilters");
	for (int i = 0; i < list.length; i++)
	{
	    enable (list[i]);
	}
    }

    Filter[] createFilters ()
    {
	FilterFactory ff;
	Filter list[] = new Filter[enabledFilters.size ()];
	for (int i = 0; i < list.length; i++)
	{
	    ff = (FilterFactory) enabledFilters.elementAt (i);
	    list[i] = ff.createFilter ();
	}
	return list;
    }

    void enable (String clazz)
    {
	try
	{
	    System.out.println ("Enabling " + clazz);
	    FilterFactory ff = (FilterFactory) (Class.forName (clazz)).newInstance ();
	    Prefs prefs = userPrefs.extract (clazz.substring (clazz.lastIndexOf ('.') + 1));
	    ff.setPrefs (prefs);
	    ff.setManager (this);
	    enabledFilters.addElement (ff);
	}
	catch (Exception e)
	{
	    System.out.println (e);
	}
    }

    void save ()
    {
	String list[] = new String[enabledFilters.size ()];
	for (int i = 0; i < list.length; i++)
 	{
	    FilterFactory ff = (FilterFactory) enabledFilters.elementAt (i);
	    list[i] = (ff.getClass ()).getName ();
	}
	userPrefs.putStringList ("muffin.enabledFilters", list);
	userPrefs.save ();
    }

    public void save (FilterFactory ff)
    {
	userPrefs.merge (ff.getPrefs ());
	userPrefs.save ();
    }
}    
