/* FilterManagerFrame.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

/**
 * @author Mark Boyns
 */
public class FilterManagerFrame extends Frame implements ActionListener, ItemListener
{
    FilterManager manager;
    BigList knownFiltersList = null;
    BigList enabledFiltersList = null;
    
    public FilterManagerFrame (FilterManager manager)
    {
	super ("Filters");

	this.manager = manager;

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));
	
	knownFiltersList = new BigList (10, false);
	knownFiltersList.addItemListener (this);
	enabledFiltersList = new BigList (10, false);
	enabledFiltersList.addItemListener (this);

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
	panel.setLayout (layout);

	Label l;
	Button b;
	GridBagConstraints c;
	Panel p;
	
	l = new Label ("Known Filters");
	l.setFont (new Font ("Fixed", Font.BOLD, 12));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);

	c = new GridBagConstraints ();
	c.gridheight = 2;
	c.insets = new Insets (0, 10, 5, 10);
	layout.setConstraints (knownFiltersList, c);
	panel.add (knownFiltersList);

	b = new Button ("Enable");
	b.addActionListener (this);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);
	
	b = new Button ("New...");
	b.addActionListener (this);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);
	
	l = new Label ("Enabled Filters");
	l.setFont (new Font ("Fixed", Font.BOLD, 12));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);

	c = new GridBagConstraints ();
	c.gridheight = 4;
	c.insets = new Insets (0, 10, 5, 10);
	layout.setConstraints (enabledFiltersList, c);
	panel.add (enabledFiltersList);

	b = new Button ("Preferences...");
	b.addActionListener (this);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);
	
	b = new Button ("Move Up");
	b.addActionListener (this);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);

	b = new Button ("Move Down");
	b.addActionListener (this);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);

	b = new Button ("Disable");
	b.addActionListener (this);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.anchor = GridBagConstraints.NORTHWEST;
	layout.setConstraints (b, c);
	panel.add (b);

	add ("Center", panel);
	
	Panel buttonPanel = new Panel ();
	b = new Button ("Save");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Close");
	b.addActionListener (this);
	buttonPanel.add (b);
	add ("South", buttonPanel);
	
 	pack ();
 	setSize (getPreferredSize ());

	updateKnownFiltersList ();
	updateEnabledFiltersList ();
    }

    void updateKnownFiltersList ()
    {
	knownFiltersList.removeAll ();
	Enumeration e = manager.knownFilters.elements ();
 	while (e.hasMoreElements ())
 	{
	    String s = (String) e.nextElement ();
	    knownFiltersList.addItem (s);
	}
    }	

    void updateEnabledFiltersList ()
    {
	enabledFiltersList.removeAll ();
	Enumeration e = manager.enabledFilters.elements ();
 	while (e.hasMoreElements ())
 	{
	    FilterFactory ff = (FilterFactory) e.nextElement ();
	    enabledFiltersList.addItem ((ff.getClass ()).getName ());
	}
    }
    
    public void hideshow ()
    {
	if (isShowing ())
	{
	    setVisible (false);
	}
	else
	{
	    show ();
	}
    }

    void enable (String clazz)
    {
	manager.enable (clazz);
	updateEnabledFiltersList ();
    }

    void viewPrefs (String clazz)
    {
	Enumeration e = manager.enabledFilters.elements ();
	while (e.hasMoreElements ())
	{
	    FilterFactory f = (FilterFactory) e.nextElement ();
	    if (clazz.equals ((f.getClass ()).getName ()))
	    {
		f.viewPrefs ();
	    }
	}
    }

    public void itemStateChanged (ItemEvent event)
    {
	Object obj = event.getItemSelectable ();
	/* XXX double click? */
	if (obj == knownFiltersList)
	{
	    //enable (knownFiltersList.getSelectedItem ());
	}
	else if (obj == enabledFiltersList)
	{
	    //viewPrefs (knownFiltersList.getSelectedItem ());
	}
    }
    
    public void actionPerformed (ActionEvent event)
    {
	String arg = event.getActionCommand ();

	if ("Close".equals (arg))
	{
	    setVisible (false);
	}
	else if ("Save".equals (arg))
	{
	    manager.save ();
	}
	else if ("Enable".equals (arg))
	{
	    int i = knownFiltersList.getSelectedIndex ();
	    if (i != -1)
	    {
		enable (knownFiltersList.getItem (i));
	    }
	}
	else if ("New...".equals (arg))
	{
	}
	else if ("Preferences...".equals (arg))
	{
	    int i = enabledFiltersList.getSelectedIndex ();
	    if (i != -1)
	    {
		viewPrefs (enabledFiltersList.getItem (i));
	    }
	}
	else if ("Move Up".equals (arg))
	{
	    int i = enabledFiltersList.getSelectedIndex ();
	    if (i > 0)
	    {
		Object prev = manager.enabledFilters.elementAt (i-1);
		Object curr = manager.enabledFilters.elementAt (i);
		manager.enabledFilters.setElementAt (curr, i-1);
		manager.enabledFilters.setElementAt (prev, i);
		updateEnabledFiltersList ();
		enabledFiltersList.select (i-1);
	    }
	}
	else if ("Move Down".equals (arg))
	{
	    int i = enabledFiltersList.getSelectedIndex ();
	    if (i < manager.enabledFilters.size () - 1)
	    {
		Object next = manager.enabledFilters.elementAt (i+1);
		Object curr = manager.enabledFilters.elementAt (i);
		manager.enabledFilters.setElementAt (curr, i+1);
		manager.enabledFilters.setElementAt (next, i);
		updateEnabledFiltersList ();
		enabledFiltersList.select (i+1);
	    }
	}
	else if ("Disable".equals (arg))
	{
	    int i = enabledFiltersList.getSelectedIndex ();
	    if (i != -1)
	    {
		manager.enabledFilters.removeElementAt (i);
		updateEnabledFiltersList ();
	    }
	}
    }
}    
