/* Http.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.net.URL;

/**
 * @author Mark Boyns
 */
class Http extends HttpRelay
{
    Http (URL url) throws java.io.IOException
    {
	super (url.getHost (), url.getPort () == -1 ? 80 : url.getPort ());
    }

    public void write (Request request) throws java.io.IOException
    {
	String oldHeadline = request.headline;
	StringBuffer head = new StringBuffer ();
	head.append (request.getCommand ());
	head.append (" ");
	head.append (request.getPath ());
	head.append (" ");
	head.append (request.getProtocol ());
	request.headline = head.toString ();
	request.write (out);
	request.headline = oldHeadline;
    }
}
