/* HttpError.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

class HttpError
{
    StringBuffer buf;
    
    HttpError (int code, String message)
    {
	String error;
	switch (code)
	{
	case 400:
	    error = "Bad Request";
	    break;

	case 403:
	    error = "Forbidden";
	    break;

	case 503:
	    error = "Service Unavailable";
	    break;

	default:
	    error = "Error";
	    break;
	}
	
	buf = new StringBuffer ();
	buf.append ("HTTP/1.0 " + code + " " + error + "\r\n");
	buf.append ("Content-type: text/html\r\n\r\n");
	buf.append ("<title>" + error + "</title>\r\n");
	buf.append ("<body bgcolor=\"#FFFFFF\">\r\n");
	buf.append ("<h1>" + error + "</h1>\r\n<hr noshade size=4>\r\n");
	buf.append (message);
	buf.append ("<p>\r\n<hr noshade size=4>\r\n");
	buf.append ("<a href=\"http://muffin.doit.org/\">");
	buf.append ("<i><img border=0 alt=\"\" src=\"http://muffin.doit.org/images/mufficon.gif\">");
	buf.append ("Generated by Muffin</a></i>");
	buf.append ("</body>\r\n");
    }

    public String toString ()
    {
	return buf.toString ();
    }
}
