/* Main.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Label;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.net.InetAddress;

/**
 * @author Mark Boyns
 */
public class Main extends Frame implements ActionListener
{
    static Options options;
    static UserPrefs userPrefs;
    Monitor monitor;
    Server server;
    OptionsFrame optionsFrame;
    FilterManager manager;
    FilterManagerFrame managerFrame;
    String infoString;
    Button suspendButton;
    
    public Main ()
    {
	super ("Muffin");

	try
	{
	    infoString = new String ("Muffin " + options.getString ("muffin.version") +
				     " running on " + (InetAddress.getLocalHost ()).getHostName () +
				     " port " + options.getString ("muffin.port"));
	    System.out.println (infoString);
	}
	catch (Exception e)
	{
	}
	    
	manager = new FilterManager (userPrefs);

	if (options.getBoolean ("muffin.noWindow"))
	{
	    TextMonitor tm = new TextMonitor (infoString);
	    tm.draw ();
	    monitor = tm;
	}
	else
	{
	    monitor = new CanvasMonitor ();
	    gui ();
	}
	
	server = new Server (options.getInteger ("muffin.port"),
			     monitor, manager, options);
	server.run ();
    }

    void gui ()
    {
	optionsFrame = new OptionsFrame (options, userPrefs);
	managerFrame = new FilterManagerFrame (manager);
	
	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	MenuBar bar = new MenuBar ();
	Menu menu = new Menu ("File");
	menu.setFont (new Font ("Helvetica", Font.BOLD, 12));
	MenuItem item = new MenuItem ("Quit");
	item.addActionListener (this);
	item.setFont (new Font ("Helvetica", Font.BOLD, 12));
	menu.add (item);
	bar.add (menu);

	menu = new Menu ("Help");
	menu.setFont (new Font ("Helvetica", Font.BOLD, 12));
	item = new MenuItem ("About Muffin...");
	item.addActionListener (this);
	item.setFont (new Font ("Helvetica", Font.BOLD, 12));
	menu.add (item);
	bar.setHelpMenu (menu);
	
	setMenuBar (bar);

	if (monitor instanceof Canvas)
	{
	    Canvas canvas = (Canvas) monitor;
	    add ("Center", canvas);
	}

	GridBagLayout layout = new GridBagLayout ();
	Panel controlPanel = new Panel ();
	controlPanel.setLayout (layout);

	GridBagConstraints c = new GridBagConstraints ();
	c.anchor = GridBagConstraints.NORTHWEST;
	c.insets = new Insets (2, 5, 2, 5);
	c.weightx = 1.0;

	Button b;
	b = new Button ("Filters...");
	b.addActionListener (this);
	layout.setConstraints (b, c);
	controlPanel.add (b);
	b = new Button ("Options...");
	b.addActionListener (this);
	layout.setConstraints (b, c);
	controlPanel.add (b);
	suspendButton = new Button ("Suspend");
	suspendButton.addActionListener (this);
	layout.setConstraints (suspendButton, c);
	controlPanel.add (suspendButton);
	b = new Button ("Stop");
	b.addActionListener (this);
	layout.setConstraints (b, c);
	controlPanel.add (b);
	
	Icon icon = new Icon ();
	c.anchor = GridBagConstraints.EAST;
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (icon, c);
	controlPanel.add (icon);
	
	add ("North", controlPanel);

	Label l = new Label (infoString);
	l.setFont (new Font ("Helvetica", Font.PLAIN, 10));
	add ("South", l);

	pack ();
	setSize (getPreferredSize ());
	show ();
    }

    public void actionPerformed (ActionEvent event)
    {
	String arg = event.getActionCommand ();
	
	if ("Quit".equals (arg))
	{
	    System.exit (0);
	}
	else if ("About Muffin...".equals (arg))
	{
	    new About (options.getString ("muffin.version"));
	}
	else if ("Stop".equals (arg))
	{
	    server.stop ();
	}
	else if ("Suspend".equals (arg))
	{
 	    suspendButton.setLabel ("Resume");
	    server.suspend ();
	    monitor.suspend ();
	}
	else if ("Resume".equals (arg))
	{
 	    suspendButton.setLabel ("Suspend");
	    server.resume ();
	    monitor.resume ();
	}
	else if ("Filters...".equals (arg))
	{
	    managerFrame.hideshow ();
	}
	else if ("Options...".equals (arg))
	{
	    optionsFrame.hideshow ();
	}
    }
    
    public static void main (String args[])
    {
	userPrefs = new UserPrefs ();
	userPrefs.load ();

	options = new Options ();
	options.merge (userPrefs);
	options.sync ();
	
	for (int i = 0; i < args.length; i++) 
	{
	    if (args[i].equalsIgnoreCase ("-port")) 
	    {
		try 
		{
		    options.putInteger ("muffin.port", Integer.parseInt (args[++i]));
		}
		catch (Exception e)
		{
		    System.out.println ("invalid port: " + args[i]);
		    System.exit (1) ;
		}
	    }
	    else if (args[i].equalsIgnoreCase ("-httpProxyHost"))
	    {
		options.putString ("muffin.httpProxyHost", args[++i]);
	    }
	    else if (args[i].equalsIgnoreCase ("-httpProxyPort"))
	    {
		try
		{
		    options.putInteger ("muffin.httpProxyPort", Integer.parseInt (args[++i]));
		}
		catch (Exception e)
		{
		    System.out.println ("invalid httpProxyPort: " + args[i]);
		    System.exit (1) ;
		}
	    }
	    else if (args[i].equalsIgnoreCase ("-nw"))
	    {
		options.putBoolean ("muffin.noWindow", true);
	    }
	    else if (args[i].equalsIgnoreCase ("-help")
		     || args[i].equalsIgnoreCase ("--help")
		     || args[i].equalsIgnoreCase ("-h"))
	    {
		System.out.println ("usage: java muffin.Main [options]\n\n"
				    + "-help                 This useful message.\n"
				    + "-httpProxyHost HOST   Use HOST as the HTTP proxy.\n"
				    + "-httpProxyPort PORT   Use PORT as the HTTP proxy port.\n"
				    + "-nw                   Don't create any windows.\n"
				    + "-port PORT            Listen on PORT for browser requests.\n");
		System.exit (1) ;
	    }
	    else 
	    {
		System.out.println ("Unknown option: " + args[i]);
		System.exit (1) ;
	    }
	}
	new Main ();
    }
}
