/* Request.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.StringTokenizer;

/**
 * @author Mark Boyns
 */
public class Request extends Message
{
    protected String command = null;
    protected String url = null;
    protected String protocol = null;
    protected String data = null;
    
    void read (BufferedReader in) throws IOException
    {
	headline = in.readLine ();

	StringTokenizer st = new StringTokenizer (headline);
	command = (String) st.nextToken ();
	url = (String) st.nextToken ();
	protocol = (String) st.nextToken ();

	readHeaders (in);

	// XXX read content-length bytes
	if (command.equals ("POST"))
	{
	    data = in.readLine ();
	}
    }

    void write (BufferedWriter out) throws IOException
    {
	String s = toString ();
	out.write (s, 0, s.length ());
	out.flush ();
    }

    public String toString ()
    {
	if (command.equals ("POST"))
	{
	    StringBuffer buf = new StringBuffer (super.toString ());
	    buf.append (data);
	    buf.append ("\r\n");
	    buf.append ("\r\n");
	    return buf.toString ();
	}
	else
	{
	    return super.toString ();
	}
    }

    public String getRequest ()
    {
	return headline;
    }

    public String getCommand ()
    {
	return command;
    }
    

    public String getURL ()
    {
	return url;
    }

    public String getProtocol ()
    {
	return protocol;
    }

    public String getHost ()
    {
	String str = getURL ();
	return str.substring (7, str.indexOf ('/', 7));
    }

    public String getPath ()
    {	
	String str = getURL ();
	int pos = 0;
	for (int i = 0; i < 3; i++)
	{
	    pos = str.indexOf ('/', pos);
	    pos++;
	}
	pos--;
	return str.substring (pos);
    }
    
    public String getDocument ()
    {
	String str = getURL ();
	return str.substring (str.lastIndexOf ('/') + 1);
    }
}
