/* UserPrefs.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;

/**
 * @author Mark Boyns
 */
public class UserPrefs extends Prefs
{
    String getUserFilename ()
    {
	String os = System.getProperty ("os.name");
	if (os.startsWith ("Windows"))
	{
	    /* Windows 95 */
	    return System.getProperty ("user.home") + "\\muffin.dat";
	}
	/* Mac? */
	else
	{
	    /* Unix */
	    return System.getProperty ("user.home") + "/.muffinrc";
	}
    }
    
    public void load ()
    {
	System.out.println ("java.version " + System.getProperty ("java.version"));
	System.out.println ("java.vendor " + System.getProperty ("java.vendor"));
	System.out.println ("java.home " + System.getProperty ("java.home"));
	System.out.println ("java.class.version " + System.getProperty ("java.class.version"));
	System.out.println ("os.name " + System.getProperty ("os.name"));
	System.out.println ("os.arch " + System.getProperty ("os.arch"));
	System.out.println ("os.version " + System.getProperty ("os.version"));
	System.out.println ("user.home " + System.getProperty ("user.home"));
	System.out.println ("user.dir " + System.getProperty ("user.dir"));

	File file = new File (getUserFilename ());
	if (!file.exists ())
	{
	    return;
	}
	System.out.println ("Loading " + file.getAbsolutePath ());
	try
	{
	    FileInputStream in = new FileInputStream (file);
	    Properties props = new Properties ();
	    props.load (in);
	    Enumeration e = props.keys ();
	    while (e.hasMoreElements ())
	    {
		String key = (String) e.nextElement ();
		put (key, props.get (key));
	    }
	    in.close ();
	}
	catch (Exception e)
	{
	    System.out.println (e);
	}
    }

    public void save ()
    {
	Properties props = new Properties ();
	Enumeration e = keys ();
	while (e.hasMoreElements ())
	{
	    String key = (String) e.nextElement ();
	    props.put (key, get (key));
	}
	File file = new File (getUserFilename ());
	System.out.println ("Saving " + file.getAbsolutePath ());
	try
	{
	    FileOutputStream out = new FileOutputStream (file);
	    props.save (out, null);
	    out.close ();
	}
	catch (Exception ex)
	{
	    System.out.println (ex);
	}
    }
}
