/* AnimationKillerFilter.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import muffin.*;
import java.io.BufferedReader;
import java.io.PushbackReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class AnimationKillerFilter implements ContentFilter
{
    Prefs prefs;
    AnimationKiller factory;
    BufferedReader in = null;
    BufferedWriter out = null;
    Request request;

    AnimationKillerFilter (AnimationKiller factory)
    {
	this.factory = factory;
    }
    
    public void setPrefs (Prefs prefs)
    {
	this.prefs = prefs;
    }

    public boolean needsFiltration (Request request, Reply reply)
    {
	this.request = request;
	return reply.getHeaderField ("Content-type").startsWith ("image/gif");
    }
    
    public void setReader (BufferedReader in)
    {
	this.in = in;
    }

    public void setWriter (BufferedWriter out)
    {
	this.out = out;
    }

    public void run ()
    {
	try
	{
	    int b;
	    char pattern[] = { 0x21, 0xff, 0x0b,
			       'N', 'E', 'T', 'S', 'C', 'A', 'P', 'E', '2', '.', '0',
			       0x03, 0x01 };
	    int index = 0;
	    boolean killed = false;
	    PushbackReader reader = new PushbackReader (in);

	    /* Look for the GIF89a block extension */
	    while ((b = reader.read ()) != -1)
	    {
		if (killed)
		{
		    out.write (b);
		    continue;
		}
		
		if (b == pattern[index])
		{
		    index++;
		    if (index == pattern.length)
		    {
			index = 0;
			killed = true;

			factory.process ("Found animation " + request.getURL () + "\n");

			if (prefs.getBoolean ("AnimationKiller.break"))
			{
			    while ((b = reader.read ()) != -1)
			    {
				/* ignore the rest */
			    }
			    break;
			}
			else
			{
			    String id = null;
			    
			    if (prefs.getInteger ("AnimationKiller.maxLoops") == -1)
			    {
				out.write (0x21);
				out.write (0xfe); /* comment extension */
				id = new String ("MUFFINED2.0");
			    }
			    else
			    {
				out.write (0x21);
				out.write (0xff); /* application extension */
				id = new String ("NETSCAPE2.0");
			    }
			    out.write (0x0b);
			    out.write (id, 0, id.length ());
			    out.write (0x03);
			    out.write (0x01);
			
			    b = reader.read ();
			    b = reader.read ();
			    if (prefs.getInteger ("AnimationKiller.maxLoops") == -1)
			    {
				out.write (0x00);
				out.write (0x00);
			    }
			    else
			    {
				out.write (prefs.getInteger ("AnimationKiller.maxLoops"));
				out.write (0x00);
			    }
			}
		    }
		}
		else if (index > 0)
		{
		    out.write (pattern, 0, index);
		    reader.unread (b);
		    index = 0;
		}
		else
		{
		    out.write (b);
		}
	    }
	    
	    out.flush ();
	    out.close ();
	}
	catch (IOException e)
	{
	}
    }
}
