/* CookieMonsterFrame.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import java.awt.*;
import java.awt.event.*;
import muffin.*;

public class CookieMonsterFrame extends Frame implements ActionListener
{
    Prefs prefs;
    CookieMonster parent;
    Checkbox eatReply, eatRequest;
    TextArea text;
    
    public CookieMonsterFrame (Prefs prefs, CookieMonster parent)
    {
	super ("Cookie Monster");

	this.prefs = prefs;
	this.parent = parent;

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
	panel.setLayout (layout);
	GridBagConstraints c;

	eatRequest = new Checkbox ("Eat Request Cookies");
	eatRequest.setState (prefs.getBoolean ("CookieMonster.eatRequestCookies"));
	eatReply = new Checkbox ("Eat Reply Cookies");
	eatReply.setState (prefs.getBoolean ("CookieMonster.eatReplyCookies"));
	
	c = new GridBagConstraints ();
	layout.setConstraints (eatRequest, c);
	panel.add (eatRequest);
	
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (eatReply, c);
	panel.add (eatReply);
	
	text = new TextArea ();
	text.setEditable (false);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (text, c);
	panel.add (text);
	
	add ("Center", panel);

	Button b;
	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 4));
	b = new Button ("Apply");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Save");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Clear");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Close");
	b.addActionListener (this);
	buttonPanel.add (b);

	add ("South", buttonPanel);
	
	pack ();
	setSize (getPreferredSize ());

	show ();
    }

    public void actionPerformed (ActionEvent event)
    {
	String arg = event.getActionCommand ();
	
	if ("Apply".equals (arg))
	{
	    prefs.putBoolean ("CookieMonster.eatReplyCookies", eatReply.getState ());
	    prefs.putBoolean ("CookieMonster.eatRequestCookies", eatRequest.getState ());
	}
	else if ("Save".equals (arg))
	{
	    parent.save ();
	}
	else if ("Close".equals (arg))
	{
	    setVisible (false);
	}
	else if ("Clear".equals (arg))
	{
	    text.setText ("");
	}
    }
}
