/* SnoopFrame.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import java.awt.*;
import java.awt.event.*;
import muffin.*;

public class SnoopFrame extends Frame implements ActionListener
{
    Prefs prefs;
    Snoop parent;
    TextArea text;
    
    public SnoopFrame (Prefs prefs, Snoop parent)
    {
	super ("Snoop");

	this.prefs = prefs;
	this.parent = parent;

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	text = new TextArea ();
	text.setEditable (false);
	add ("Center", text);

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 2));
	Button b;
	b = new Button ("Clear");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Close");
	b.addActionListener (this);
	buttonPanel.add (b);
	add ("South", buttonPanel);

	pack ();
	setSize (getPreferredSize ());

	show ();
    }

    public void actionPerformed (ActionEvent event)
    {
	String arg = event.getActionCommand ();
	
	if ("Close".equals (arg))
	{
	    setVisible (false);
	}
	else if ("Clear".equals (arg))
	{
	    text.setText ("");
	}
    }
}
