/* StatsFrame.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import java.awt.*;
import java.awt.event.*;
import java.util.Hashtable;
import java.util.Enumeration;
import muffin.*;

public class StatsFrame extends Frame implements ActionListener
{
    Prefs prefs;
    Stats parent;
    TextArea text;

    public StatsFrame (Prefs prefs, Stats parent)
    {
	super ("Stats");

	this.prefs = prefs;
	this.parent = parent;

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	text = new TextArea ();
        text.setEditable (false);
        add ("Center", text);

	Button b;
	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 3));
	b = new Button ("Update");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Reset");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Close");
	b.addActionListener (this);
	buttonPanel.add (b);

	add ("South", buttonPanel);
	
	pack ();
	setSize (getPreferredSize ());

	show ();
    }

    void reset ()
    {
	text.setText ("");
	parent.reset ();
    }

    void print (Hashtable h)
    {
        String key;
        Integer count;
        int total = 0;

        for (Enumeration e = h.keys (); e.hasMoreElements (); )
        {
            key = (String) e.nextElement ();
            count = (Integer) h.get (key);
            text.append ("    " + key + ": " + count + "\n");
            total += count.intValue ();
        }
        text.append ("    TOTAL: " + total + "\n");
    }
    
    void update ()
    {
	String key;
        Integer count;

        text.setText ("");

//         text.append ("Filter started: " + startDate.toLocaleString());
//         text.append ("\n");

//         text.append ("Current date: " + (new Date ()).toLocaleString ());
//         text.append ("\n");
        
        text.append ("Requests: ");
        text.append (parent.requests + "\n");
	text.append ("\n");
        
        text.append ("Replies: ");
        text.append (parent.replies + "\n");
	text.append ("\n");
        
        text.append ("Hosts:\n");
        print (parent.hosts);
	text.append ("\n");
        
        text.append ("Servers:\n");
        print (parent.servers);
	text.append ("\n");
        
        text.append ("Content-types:\n");
        print (parent.contentTypes);
	text.append ("\n");

        text.append ("Content-lengths:\n");
        print (parent.contentLengths);
	text.append ("\n");
    }
    
    public void actionPerformed (ActionEvent event)
    {
	String arg = event.getActionCommand ();
	
	if ("Update".equals (arg))
	{
	    update ();
	}
	else if ("Reset".equals (arg))
	{
	    reset ();
	}
	else if ("Close".equals (arg))
	{
	    setVisible (false);
	}
    }
}
