/* TestFilter.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import muffin.*;
import muffin.html.HtmlTokenizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class TestFilter implements ContentFilter
{
    Prefs prefs;
    Test factory;
    BufferedReader in = null;
    BufferedWriter out = null;
    Reply reply;

    TestFilter (Test factory)
    {
	this.factory = factory;
    }
    
    public void setPrefs (Prefs prefs)
    {
	this.prefs = prefs;
    }

    public boolean needsFiltration (Request request, Reply reply)
    {
	return reply.getHeaderField ("Content-type").startsWith ("text/html");
    }
    
    public void setReader (BufferedReader in)
    {
	this.in = in;
    }

    public void setWriter (BufferedWriter out)
    {
	this.out = out;
    }
    
    public void run ()
    {
	try
	{
	    HtmlTokenizer html = new HtmlTokenizer (in);
	    int token;
	    String s;
	    
            while ((token = html.getToken ()) != HtmlTokenizer.TT_EOF)
            {
		switch (token)
		{
		case HtmlTokenizer.TT_TAG:
		    s = html.getTokenValue ();
		    out.write (s, 0, s.length ());
		    break;

		case HtmlTokenizer.TT_TEXT:
		    s = html.getTokenValue ();
		    out.write (s, 0, s.length ());
		    break;
                }
            }
	    
	    String msg = new String ("<p><i>Processed by <a href=http://muffin.doit.org/>Muffin</a></i>\n");
	    out.write (msg, 0, msg.length ());
	    out.flush ();
	    out.close ();
	}
	catch (IOException e)
	{
	}
    }
}
