/* HtmlTokenizer.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.html;

import java.io.Reader;
import java.io.PushbackReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.net.URL;

public class HtmlTokenizer extends PushbackReader
{
    public static final int TT_EOF = -1;
    public static final int TT_TAG = -2;
    public static final int TT_TEXT = -4;

    StringBuffer buf = new StringBuffer ();
    
    public HtmlTokenizer (Reader in)
    {
	super (in);
    }

    public String getTokenValue ()
    {
	return buf.toString ();
    }

    public int getToken () throws IOException
    {
	int type = 0;
	int ch;
	
	buf.setLength (0);

	for (;;)
	{
	    ch = read ();

	    if (ch == -1)
	    {
		if (type == 0)
		{
		    type = TT_EOF;
		}
		return type;
	    }
	    else if (ch == '<')
	    {
		if (type != 0)
		{
		    unread (ch);
		    break;
		}
		type = TT_TAG;
	    }
	    else if (type == 0)
	    {
		type = TT_TEXT;
	    }

	    buf.append ((char) ch);

	    if (ch == '>')
	    {
		break;
	    }
	}
	return type;
    }
}
