/*
 * Decompiled with CFR 0.152.
 */
package JP.ac.osaka_u.ender.util.regex;

class Chars {
    public static final int EMPTY = 0;
    public static final int CHARACTER = 1;
    public static final int LINE_HEAD = 2;
    public static final int LINE_TAIL = 3;
    public static final int NONE = 4;
    private char begin;
    private char end;
    private int type;

    private Chars() {
    }

    public Chars(char c) {
        this(c, c);
    }

    public Chars(char c, char c2) {
        this.begin = c;
        this.end = c2;
        this.type = 1;
    }

    public Chars(int n) {
        this.type = n;
    }

    public char begin() {
        return this.begin;
    }

    public char end() {
        return this.end;
    }

    public void set(char c, char c2) {
        this.begin = c;
        this.end = c2;
    }

    public int type() {
        return this.type;
    }

    public void setBegin(char c) {
        this.begin = c;
    }

    public void setEnd(char c) {
        this.end = c;
    }

    public boolean has(char c) {
        if (this.type == 4) {
            return false;
        }
        return this.begin <= c && c <= this.end;
    }

    public boolean hasChars(Chars chars) {
        if (this.type == 4) {
            return false;
        }
        return this.begin <= chars.begin() && chars.begin() <= this.end || this.begin <= chars.end() && chars.end() <= this.end;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Chars) {
            Chars chars = (Chars)object;
            if (this.type == 1) {
                return this.begin == chars.begin && this.end == chars.end;
            }
            return this.type == chars.type;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.type == 0;
    }

    private String escape(char c) {
        String string;
        switch (c) {
            case '\t': {
                string = "\\t";
                break;
            }
            case '\b': {
                string = "\\b";
                break;
            }
            case '\r': {
                string = "\\r";
                break;
            }
            case '\n': {
                string = "\\n";
                break;
            }
            default: {
                string = new Character(c).toString();
            }
        }
        return string;
    }

    public String toString() {
        String string = "";
        switch (this.type) {
            case 1: {
                if (this.begin == this.end) {
                    string = "'" + this.escape(this.begin) + "'";
                    break;
                }
                string = "'" + this.escape(this.begin) + "-" + this.escape(this.end) + "'";
                break;
            }
            case 0: {
                string = "EMPTY";
                break;
            }
            case 2: {
                string = "LHEAD";
                break;
            }
            case 3: {
                string = "LTAIL";
                break;
            }
            case 4: {
                string = "NONE";
                break;
            }
        }
        return string;
    }

    public void setType(int n) {
        this.type = n;
    }
}

