/*
 * Decompiled with CFR 0.152.
 */
package JP.ac.osaka_u.ender.util.regex;

import JP.ac.osaka_u.ender.util.regex.DList;
import JP.ac.osaka_u.ender.util.regex.DSList;
import JP.ac.osaka_u.ender.util.regex.DState;
import JP.ac.osaka_u.ender.util.regex.NList;
import JP.ac.osaka_u.ender.util.regex.RTree;
import JP.ac.osaka_u.ender.util.regex.RegExpNFA;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;

class RegExpDFA {
    private RegExpNFA nfa;
    private Hashtable dfa = new Hashtable();
    private DState initialDfaState;
    private int count;
    private boolean hasLHead = false;
    private boolean hasLTail = false;

    public RegExpDFA(RegExpNFA regExpNFA) {
        this.nfa = regExpNFA;
        this.convertNfaToDfa();
    }

    private void markEmptyTransition(BitSet bitSet, int n) {
        bitSet.set(n);
        NList nList = this.nfa.getNList(n);
        while (nList != null) {
            if (nList.chars().isEmpty() && !bitSet.get(nList.to())) {
                this.markEmptyTransition(bitSet, nList.to());
            }
            nList = nList.next();
        }
    }

    private void collectEmptyTransition(BitSet bitSet) {
        int n = 0;
        while (n < this.nfa.count()) {
            if (bitSet.get(n)) {
                this.markEmptyTransition(bitSet, n);
            }
            ++n;
        }
    }

    private DState registerDState(BitSet bitSet) {
        DState dState;
        Enumeration enumeration = this.dfa.elements();
        while (enumeration.hasMoreElements()) {
            dState = (DState)enumeration.nextElement();
            if (!dState.nfaStateSet().equals(bitSet)) continue;
            return dState;
        }
        dState = new DState(bitSet, false, bitSet.get(this.nfa.exit()), null);
        this.dfa.put(new Integer(this.count), dState);
        ++this.count;
        return dState;
    }

    private DState fetchUnvisitedDState() {
        Enumeration enumeration = this.dfa.elements();
        while (enumeration.hasMoreElements()) {
            DState dState = (DState)enumeration.nextElement();
            if (dState.visited()) continue;
            return dState;
        }
        return null;
    }

    private DList computeReachableNState(DState dState) {
        boolean bl = false;
        BitSet bitSet = dState.nfaStateSet();
        DList dList = null;
        int n = 0;
        while (n < this.nfa.count()) {
            if (bitSet.get(n)) {
                NList nList = this.nfa.getNList(n);
                while (nList != null) {
                    if (!nList.chars().isEmpty()) {
                        bl = false;
                        DList dList2 = dList;
                        while (dList2 != null) {
                            if (dList2.chars().equals(nList.chars())) {
                                dList2.to().set(nList.to());
                                bl = true;
                                break;
                            }
                            dList2 = dList2.next();
                        }
                        if (!bl) {
                            DList dList3 = new DList(nList.chars(), new BitSet(), null);
                            dList3.to().set(nList.to());
                            dList3.setNext(dList);
                            dList = dList3;
                        }
                    }
                    nList = nList.next();
                }
            }
            ++n;
        }
        return dList;
    }

    private void convertNfaToDfa() {
        DState dState;
        BitSet bitSet = new BitSet();
        bitSet.set(this.nfa.entry());
        this.collectEmptyTransition(bitSet);
        this.initialDfaState = this.registerDState(bitSet);
        while ((dState = this.fetchUnvisitedDState()) != null) {
            dState.visit();
            DList dList = this.computeReachableNState(dState);
            while (dList != null) {
                this.collectEmptyTransition(dList.to());
                DSList dSList = new DSList(dList.chars(), null, null);
                dSList.setTo(this.registerDState(dList.to()));
                dSList.setNext(dState.next());
                dState.setNext(dSList);
                dList = dList.next();
            }
        }
        this.hasLHead = this.nfa.hasLHead();
        this.hasLTail = this.nfa.hasLTail();
    }

    public boolean hasLHead() {
        return this.hasLHead;
    }

    public boolean hasLTail() {
        return this.hasLTail;
    }

    public DState nextState(DState dState, char c) {
        DSList dSList = dState.next();
        while (dSList != null) {
            if (dSList.chars().has(c)) {
                return dSList.to();
            }
            dSList = dSList.next();
        }
        return null;
    }

    public DState nextState(DState dState, int n) {
        DSList dSList = dState.next();
        while (dSList != null) {
            if (dSList.chars().type() == n) {
                return dSList.to();
            }
            dSList = dSList.next();
        }
        return null;
    }

    public DState initialState() {
        return this.initialDfaState;
    }

    public int count() {
        return this.count;
    }

    public DState getDState(int n) {
        Integer n2 = new Integer(n);
        return (DState)this.dfa.get(n2);
    }

    public RegExpNFA getNfa() {
        return this.nfa;
    }

    public RTree getTree() {
        return this.nfa.getTree();
    }
}

