/*
 * Decompiled with CFR 0.152.
 */
package JP.ac.osaka_u.ender.util.regex;

import JP.ac.osaka_u.ender.util.regex.DSList;
import JP.ac.osaka_u.ender.util.regex.NFABuildException;
import JP.ac.osaka_u.ender.util.regex.NList;
import JP.ac.osaka_u.ender.util.regex.RTree;
import JP.ac.osaka_u.ender.util.regex.RegExp;
import JP.ac.osaka_u.ender.util.regex.RegExpDFA;
import JP.ac.osaka_u.ender.util.regex.RegExpNFA;
import JP.ac.osaka_u.ender.util.regex.RegExpSyntaxException;
import java.io.DataInputStream;
import java.io.IOException;

class RegExpDebug {
    private RegExpDebug() {
    }

    public static void main(String[] stringArray) {
        RegExp regExp = new RegExp();
        DataInputStream dataInputStream = new DataInputStream(System.in);
        try {
            while (true) {
                System.out.println("Pattern ?");
                String string = dataInputStream.readLine();
                if (string == null) break;
                regExp.setPattern(string);
                System.out.println("Parse \"" + regExp + "\":");
                System.out.println("dump tree...");
                System.out.println(regExp.treeString());
                System.out.println("dump NFA...");
                System.out.println(regExp.nfaString());
                System.out.println("dump DFA...");
                System.out.println(regExp.dfaString());
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
        catch (RegExpSyntaxException regExpSyntaxException) {
            System.out.println(regExpSyntaxException);
            return;
        }
        catch (NFABuildException nFABuildException) {
            System.out.println(nFABuildException);
            return;
        }
    }

    public static String dfaToString(RegExpDFA regExpDFA) {
        String string = "";
        int n = 0;
        while (n < regExpDFA.count()) {
            int n2;
            string = String.valueOf(string) + "state " + n + (regExpDFA.getDState(n).accepted() ? "A" : " ") + ": ";
            DSList dSList = regExpDFA.getDState(n).next();
            while (dSList != null) {
                n2 = 0;
                while (n2 < regExpDFA.count()) {
                    if (regExpDFA.getDState(n2) == dSList.to()) break;
                    ++n2;
                }
                string = String.valueOf(string) + "(" + dSList.chars().toString() + " => " + n2 + ") ";
                dSList = dSList.next();
            }
            string = String.valueOf(string) + "... { ";
            n2 = 0;
            while (n2 < regExpDFA.getNfa().count()) {
                if (regExpDFA.getDState(n).nfaStateSet().get(n2)) {
                    string = String.valueOf(string) + n2 + " ";
                }
                ++n2;
            }
            string = String.valueOf(string) + "} ";
            string = String.valueOf(string) + "\n";
            ++n;
        }
        return string;
    }

    public static String nfaToString(RegExpNFA regExpNFA) {
        String string = "";
        int n = 0;
        while (regExpNFA.getNList(n) != null || n == regExpNFA.exit()) {
            if (regExpNFA.getNList(n) != null) {
                string = String.valueOf(string) + "state " + n + ": ";
                NList nList = regExpNFA.getNList(n);
                while (nList != null) {
                    string = String.valueOf(string) + "(" + nList.chars().toString() + " => " + nList.to() + ") ";
                    nList = nList.next();
                }
                string = String.valueOf(string) + "\n";
            } else if (n == regExpNFA.exit()) {
                string = String.valueOf(string) + "state " + n + ": exit\n";
            }
            ++n;
        }
        return string;
    }

    public static String treeToString(RTree rTree) {
        String string;
        switch (rTree.operation()) {
            case 1: {
                string = rTree.chars().toString();
                break;
            }
            case 5: {
                string = "LHEAD";
                break;
            }
            case 6: {
                string = "LTAIL";
                break;
            }
            case 2: {
                string = "(concat " + RegExpDebug.treeToString(rTree.left()) + " " + RegExpDebug.treeToString(rTree.right()) + ")";
                break;
            }
            case 3: {
                string = "(or " + RegExpDebug.treeToString(rTree.left()) + " " + RegExpDebug.treeToString(rTree.right()) + ")";
                break;
            }
            case 4: {
                string = "(closure " + RegExpDebug.treeToString(rTree.left()) + ")";
                break;
            }
            case 0: {
                string = "EMPTY";
                break;
            }
            default: {
                string = "This can't happen in <dumpTree>";
            }
        }
        return string;
    }
}

