/*
 * Decompiled with CFR 0.152.
 */
package UK.co.demon.asmodeus.util;

import UK.co.demon.asmodeus.util.CharStack;
import UK.co.demon.asmodeus.util.FileLineEnumerator;
import UK.co.demon.asmodeus.util.MultiSearch;
import UK.co.demon.asmodeus.util.MultiSearchResult;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;

public class MultiSearchReader
extends MultiSearch {
    public static String RCSID = "$Id: MultiSearchReader.java,v 2.3 1997/06/18 07:04:52 joel Exp $";
    protected CharStack backtrackBuffer;
    protected int offset;
    protected int backtrackCount;
    protected Writer sink;
    protected int inTag = 0;
    public static final int OUTSIDE_TAG = 0;
    public static final int ENTERING_TAG = 1;
    public static final int INSIDE_TAG = 2;

    public MultiSearchReader(Enumeration enumeration, boolean bl, Writer writer) {
        super(enumeration, bl);
        this.sink = writer;
    }

    protected char getNextCandidate(Object object, int n) throws IOException, IndexOutOfBoundsException {
        char c;
        if (n > this.offset + 1) {
            throw new IndexOutOfBoundsException(String.valueOf(n) + ">" + (this.offset + 1));
        }
        if (this.backtrackCount > 0) {
            char c2 = this.backtrackBuffer.pop(this.backtrackCount--);
            return c2;
        }
        ++this.offset;
        try {
            if (!((Reader)object).ready()) {
                throw new IndexOutOfBoundsException();
            }
            c = (char)((Reader)object).read();
        }
        catch (IOException iOException) {
            throw new IndexOutOfBoundsException();
        }
        if (this.backtrackBuffer == null) {
            this.backtrackBuffer = new CharStack(this.maxLength, this.sink);
        }
        this.backtrackBuffer.push(c);
        if (this.inTag == 1) {
            this.inTag = 2;
        }
        if (c == '<' && this.inTag == 0) {
            this.inTag = 1;
        }
        if (c == '>' && this.inTag == 2) {
            this.inTag = 0;
        }
        return c;
    }

    public int getTagStatus() {
        return this.inTag;
    }

    protected void backtrack(int n) {
        this.backtrackCount = n;
    }

    public MultiSearchResult search(int n, Object object) throws IOException {
        MultiSearchResult multiSearchResult = super.search(n, object);
        if (multiSearchResult == null && this.backtrackBuffer == null) {
            return multiSearchResult;
        }
        if (multiSearchResult != null) {
            this.backtrackBuffer.flush(multiSearchResult.getMatch().length());
        } else {
            this.backtrackBuffer.flushAll();
        }
        return multiSearchResult;
    }

    public static void main(String[] stringArray) throws IOException {
        File file = new File(stringArray[0]);
        FileReader fileReader = new FileReader(file);
        File file2 = new File(stringArray[1]);
        FileLineEnumerator fileLineEnumerator = new FileLineEnumerator(new FileReader(file2));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.err);
        MultiSearchReader multiSearchReader = new MultiSearchReader(fileLineEnumerator, false, outputStreamWriter);
        MultiSearchResult multiSearchResult = new MultiSearchResult(-1, " ");
        while (multiSearchResult != null) {
            multiSearchResult = multiSearchReader.search(multiSearchResult.getOffset() + multiSearchResult.getMatch().length(), fileReader);
            System.err.println(multiSearchResult);
        }
        ((Writer)outputStreamWriter).close();
    }
}

