/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import muffin.BigList;
import muffin.FilterFactory;
import muffin.FilterManager;
import muffin.NewFilterFrame;
import sdsu.compare.StringIgnoreCaseComparer;
import sdsu.util.SortedList;

public class FilterManagerFrame
extends Frame
implements ActionListener,
ItemListener,
WindowListener {
    FilterManager manager;
    BigList knownFiltersList;
    BigList enabledFiltersList;

    public FilterManagerFrame(FilterManager filterManager) {
        super("Filters");
        this.manager = filterManager;
        ((Component)this).setBackground(Color.lightGray);
        ((Component)this).setFont(new Font("Helvetica", 1, 12));
        this.knownFiltersList = new BigList(10, false);
        this.knownFiltersList.addItemListener(this);
        this.enabledFiltersList = new BigList(10, false);
        this.enabledFiltersList.addItemListener(this);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        Label label = new Label("Known Filters");
        label.setFont(new Font("Fixed", 1, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        gridBagLayout.setConstraints(this.knownFiltersList, gridBagConstraints);
        panel.add(this.knownFiltersList);
        Button button = new Button("Enable");
        button.setActionCommand("doEnable");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        button = new Button("New...");
        button.setActionCommand("doNew");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        button = new Button("Delete");
        button.setActionCommand("doDelete");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        label = new Label("Enabled Filters");
        label.setFont(new Font("Fixed", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        gridBagLayout.setConstraints(this.enabledFiltersList, gridBagConstraints);
        panel.add(this.enabledFiltersList);
        button = new Button("Preferences...");
        button.setActionCommand("doPrefs");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        button = new Button("Move Up");
        button.setActionCommand("doUp");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        button = new Button("Move Down");
        button.setActionCommand("doDown");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        button = new Button("Disable");
        button.setActionCommand("doDisable");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        this.add("Center", panel);
        Panel panel2 = new Panel();
        button = new Button("Save");
        button.setActionCommand("doSave");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Close");
        button.setActionCommand("doClose");
        button.addActionListener(this);
        panel2.add(button);
        this.add("South", panel2);
        this.addWindowListener(this);
        this.updateKnownFiltersList();
        this.updateEnabledFiltersList();
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
    }

    void updateKnownFiltersList() {
        if (this.knownFiltersList.getItemCount() > 0) {
            this.knownFiltersList.removeAll();
        }
        Enumeration enumeration = this.manager.knownFilters.elements();
        SortedList sortedList = new SortedList(StringIgnoreCaseComparer.getInstance());
        while (enumeration.hasMoreElements()) {
            sortedList.addElement((String)enumeration.nextElement());
        }
        enumeration = sortedList.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.knownFiltersList.addItem(string);
        }
    }

    void updateEnabledFiltersList() {
        if (this.enabledFiltersList.getItemCount() > 0) {
            this.enabledFiltersList.removeAll();
        }
        Enumeration enumeration = this.manager.enabledFilters.elements();
        while (enumeration.hasMoreElements()) {
            FilterFactory filterFactory = (FilterFactory)enumeration.nextElement();
            this.enabledFiltersList.addItem(filterFactory.getClass().getName());
        }
    }

    public void hideshow() {
        if (this.isShowing()) {
            ((Component)this).setVisible(false);
            return;
        }
        this.show();
    }

    void enable(String string) {
        this.manager.enable(string);
        this.updateEnabledFiltersList();
    }

    void viewPrefs(String string) {
        Enumeration enumeration = this.manager.enabledFilters.elements();
        while (enumeration.hasMoreElements()) {
            FilterFactory filterFactory = (FilterFactory)enumeration.nextElement();
            if (!string.equals(filterFactory.getClass().getName())) continue;
            filterFactory.viewPrefs();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("doClose".equals(string)) {
            ((Component)this).setVisible(false);
            return;
        }
        if ("doSave".equals(string)) {
            this.manager.save();
            return;
        }
        if ("doEnable".equals(string)) {
            int n = this.knownFiltersList.getSelectedIndex();
            if (n != -1) {
                this.enable(this.knownFiltersList.getItem(n));
                return;
            }
        } else {
            int n;
            if ("doNew".equals(string)) {
                new NewFilterFrame(this.manager);
                return;
            }
            if ("doDelete".equals(string)) {
                int n2 = this.knownFiltersList.getSelectedIndex();
                if (n2 != -1) {
                    this.manager.remove(n2);
                    return;
                }
            } else if ("doPrefs".equals(string)) {
                int n3 = this.enabledFiltersList.getSelectedIndex();
                if (n3 != -1) {
                    this.viewPrefs(this.enabledFiltersList.getItem(n3));
                    return;
                }
            } else if ("doUp".equals(string)) {
                int n4 = this.enabledFiltersList.getSelectedIndex();
                if (n4 > 0) {
                    Object e = this.manager.enabledFilters.elementAt(n4 - 1);
                    Object e2 = this.manager.enabledFilters.elementAt(n4);
                    this.manager.enabledFilters.setElementAt(e2, n4 - 1);
                    this.manager.enabledFilters.setElementAt(e, n4);
                    this.updateEnabledFiltersList();
                    this.enabledFiltersList.select(n4 - 1);
                    return;
                }
            } else if ("doDown".equals(string)) {
                int n5 = this.enabledFiltersList.getSelectedIndex();
                if (n5 != -1 && n5 < this.manager.enabledFilters.size() - 1) {
                    Object e = this.manager.enabledFilters.elementAt(n5 + 1);
                    Object e3 = this.manager.enabledFilters.elementAt(n5);
                    this.manager.enabledFilters.setElementAt(e3, n5 + 1);
                    this.manager.enabledFilters.setElementAt(e, n5);
                    this.updateEnabledFiltersList();
                    this.enabledFiltersList.select(n5 + 1);
                    return;
                }
            } else if ("doDisable".equals(string) && (n = this.enabledFiltersList.getSelectedIndex()) != -1) {
                this.manager.disable(n);
                this.updateEnabledFiltersList();
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

