/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.net.Socket;
import java.net.URL;
import muffin.AdjustablePipedInputStream;
import muffin.Client;
import muffin.ContentFilter;
import muffin.Filter;
import muffin.FilterException;
import muffin.FilterManager;
import muffin.Http;
import muffin.HttpError;
import muffin.HttpRelay;
import muffin.Httpd;
import muffin.Monitor;
import muffin.Options;
import muffin.Proxy;
import muffin.Reply;
import muffin.ReplyFilter;
import muffin.Request;
import muffin.RequestFilter;

public class Handler
extends Thread {
    Monitor monitor;
    FilterManager manager;
    Options options;
    Client client;
    Socket socket;
    Request request;
    Reply reply;
    HttpRelay http;
    int currentLength;
    int contentLength;
    Filter[] filterList;
    boolean isFiltered = false;

    public Handler(ThreadGroup threadGroup, Runnable runnable, Monitor monitor, FilterManager filterManager, Options options) {
        super(threadGroup, runnable);
        this.monitor = monitor;
        this.manager = filterManager;
        this.options = options;
    }

    public void doit(Socket socket) {
        this.socket = socket;
        this.start();
    }

    public synchronized void close() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.http != null) {
            this.http.close();
        }
    }

    public void run() {
        this.filterList = this.manager.createFilters();
        try {
            this.client = new Client(this.socket);
            this.request = this.client.read();
            if (!this.request.getURL().startsWith("http://")) {
                this.request.setURL("http://" + this.options.getString("muffin.host") + ":" + this.options.getString("muffin.port") + this.request.getURL());
            }
            if (!this.options.getBoolean("muffin.passthru")) {
                this.filter(this.request);
            }
            this.monitor.register(this);
            this.http = Httpd.sendme(this.request) ? new Httpd(this.socket) : (this.options.useProxy() ? new Proxy(this.options.getString("muffin.httpProxyHost"), this.options.getInteger("muffin.httpProxyPort")) : new Http(new URL(this.request.getURL())));
            this.http.write(this.request);
            this.monitor.update(this);
            this.reply = this.http.read();
            if (!this.options.getBoolean("muffin.passthru")) {
                this.filter(this.reply);
            }
            this.monitor.update(this);
            try {
                this.contentLength = Integer.parseInt(this.reply.getHeaderField("Content-length"));
            }
            catch (Exception exception) {
                this.contentLength = 0;
            }
            this.currentLength = 0;
            this.monitor.update(this);
            if (!this.options.getBoolean("muffin.passthru")) {
                this.filter(this.http.getInputStream(), this.client.getOutputStream());
            } else {
                this.client.write(this.reply);
                this.copy(this.http.getInputStream(), this.client.getOutputStream(), true);
            }
        }
        catch (Exception exception) {
            this.error(this.client.getOutputStream(), exception, this.request);
        }
        this.close();
        this.monitor.unregister(this);
    }

    void filter(Reply reply) throws FilterException {
        int n = 0;
        while (n < this.filterList.length) {
            if (this.filterList[n] instanceof ReplyFilter) {
                ((ReplyFilter)this.filterList[n]).filter(reply);
            }
            ++n;
        }
    }

    void filter(Request request) throws FilterException {
        int n = 0;
        while (n < this.filterList.length) {
            if (this.filterList[n] instanceof RequestFilter) {
                ((RequestFilter)this.filterList[n]).filter(request);
            }
            ++n;
        }
    }

    void xfilter(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = this.contentLength > 0 ? this.contentLength : 8192;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        System.out.println("Reading into memory");
        this.copy(inputStream, byteArrayOutputStream, true);
        System.out.println(String.valueOf(byteArrayOutputStream.size()) + " bytes");
        System.out.println("Filtering");
        int n2 = 0;
        while (n2 < this.filterList.length) {
            ContentFilter contentFilter;
            if (this.filterList[n2] instanceof ContentFilter && (contentFilter = (ContentFilter)this.filterList[n2]).needsFiltration(this.request, this.reply)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                byteArrayOutputStream = new ByteArrayOutputStream(n);
                contentFilter.setInputStream(byteArrayInputStream);
                contentFilter.setOutputStream(byteArrayOutputStream);
                contentFilter.run();
            }
            ++n2;
        }
        this.client.write(this.reply);
        System.out.println("Sending to client");
        this.copy(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), outputStream, false);
    }

    void filter(InputStream inputStream, OutputStream outputStream) throws IOException {
        InputStream inputStream2;
        OutputStream outputStream2;
        int n = 8192;
        int n2 = 0;
        while (n2 < this.filterList.length) {
            ContentFilter contentFilter;
            if (this.filterList[n2] instanceof ContentFilter && (contentFilter = (ContentFilter)this.filterList[n2]).needsFiltration(this.request, this.reply)) {
                outputStream2 = new PipedOutputStream();
                inputStream2 = new AdjustablePipedInputStream((PipedOutputStream)outputStream2, n);
                contentFilter.setInputStream(inputStream);
                contentFilter.setOutputStream(outputStream2);
                Thread thread = new Thread(contentFilter);
                try {
                    thread.setPriority(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                thread.start();
                inputStream = inputStream2;
                this.isFiltered = true;
            }
            ++n2;
        }
        if (this.isFiltered) {
            int n3 = this.contentLength > 0 ? this.contentLength : n;
            outputStream2 = new ByteArrayOutputStream(n3);
            this.copy(inputStream, outputStream2, true);
            inputStream2 = new ByteArrayInputStream(((ByteArrayOutputStream)outputStream2).toByteArray());
            if (this.reply.containsHeaderField("Content-length")) {
                this.reply.setHeaderField("Content-length", ((ByteArrayOutputStream)outputStream2).size());
            }
            this.client.write(this.reply);
            this.copy(inputStream2, outputStream, false);
            return;
        }
        this.client.write(this.reply);
        this.copy(inputStream, outputStream, true);
    }

    public int getTotalBytes() {
        if (this.contentLength > 0) {
            return this.contentLength;
        }
        return 0;
    }

    public int getCurrentBytes() {
        return this.currentLength;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.contentLength > 0) {
            stringBuffer.append((int)((float)this.currentLength / (float)this.contentLength * 100.0f));
            stringBuffer.append("% of ");
            stringBuffer.append(this.contentLength / 1024);
            stringBuffer.append("k");
        } else {
            stringBuffer.append(this.currentLength / 1024);
            stringBuffer.append("k");
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.request.getURL());
        return stringBuffer.toString();
    }

    void error(OutputStream outputStream, Exception exception, Request request) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("While trying to retrieve the URL: <a href=\"" + request.getURL() + "\">" + request.getURL() + "</a>\r\n");
        stringBuffer.append("<p>\r\nThe following error was encountered:\r\n<p>\r\n");
        stringBuffer.append("<ul><li>" + exception.toString() + "</ul>\r\n");
        String string = new HttpError(this.options, 400, stringBuffer.toString()).toString();
        try {
            outputStream.write(string.getBytes(), 0, string.length());
            outputStream.flush();
            return;
        }
        catch (Exception exception2) {
            return;
        }
    }

    void copy(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        int n;
        int n2 = 8192;
        byte[] byArray = new byte[n2];
        while ((n = inputStream.read(byArray, 0, n2)) > 0) {
            outputStream.write(byArray, 0, n);
            if (!bl) continue;
            this.currentLength += n;
            this.monitor.update(this);
        }
        outputStream.flush();
    }
}

