/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import muffin.OptionsFrame;
import muffin.Prefs;
import muffin.UserPrefs;

public class Options
extends Prefs {
    OptionsFrame frame;
    Vector hostsAllow;
    Vector hostsDeny;
    Vector adminAllow;
    Vector adminDeny;
    boolean noWindow = false;
    UserPrefs prefs;

    public Options(UserPrefs userPrefs) {
        this.prefs = userPrefs;
        this.putString("muffin.port", "51966");
        this.putString("muffin.httpProxyHost", "");
        this.putString("muffin.httpProxyPort", "");
        this.putBoolean("muffin.noWindow", false);
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.putString("muffin.hostsAllow", inetAddress.getHostAddress());
        }
        catch (Exception exception) {
            this.putString("muffin.hostsAllow", "ALL");
        }
        this.putString("muffin.hostsDeny", "ALL");
        this.putString("muffin.adminAllow", this.getString("muffin.hostsAllow"));
        this.putString("muffin.adminDeny", "ALL");
        this.sync();
        this.merge(userPrefs);
    }

    public void createFrame() {
        if (this.frame == null) {
            this.frame = new OptionsFrame(this, this.prefs);
        }
        this.frame.hideshow();
    }

    void updateHostsAllow() {
        this.hostsAllow = new Vector(100);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString("muffin.hostsAllow"), ", \t");
        while (stringTokenizer.hasMoreTokens()) {
            this.hostsAllow.addElement(stringTokenizer.nextToken());
        }
    }

    void updateHostsDeny() {
        this.hostsDeny = new Vector(100);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString("muffin.hostsDeny"), ", \t");
        while (stringTokenizer.hasMoreTokens()) {
            this.hostsDeny.addElement(stringTokenizer.nextToken());
        }
    }

    void updateAdminAllow() {
        this.adminAllow = new Vector(100);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString("muffin.adminAllow"), ", \t");
        while (stringTokenizer.hasMoreTokens()) {
            this.adminAllow.addElement(stringTokenizer.nextToken());
        }
    }

    void updateAdminDeny() {
        this.adminDeny = new Vector(100);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString("muffin.adminDeny"), ", \t");
        while (stringTokenizer.hasMoreTokens()) {
            this.adminDeny.addElement(stringTokenizer.nextToken());
        }
    }

    public void sync() {
        this.updateHostsAllow();
        this.updateHostsDeny();
        this.updateAdminAllow();
        this.updateAdminDeny();
    }

    boolean hostAccess(InetAddress inetAddress) {
        String string;
        String string2 = inetAddress.getHostAddress();
        Enumeration enumeration = this.hostsAllow.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.equals("ALL") && !string2.startsWith(string)) continue;
            return true;
        }
        enumeration = this.hostsDeny.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.equals("ALL") && !string2.startsWith(string)) continue;
            return false;
        }
        return true;
    }

    boolean adminAccess(InetAddress inetAddress) {
        String string;
        String string2 = inetAddress.getHostAddress();
        Enumeration enumeration = this.adminAllow.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.equals("ALL") && !string2.startsWith(string)) continue;
            return true;
        }
        enumeration = this.adminDeny.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.equals("ALL") && !string2.startsWith(string)) continue;
            return false;
        }
        return true;
    }

    boolean useProxy() {
        return this.getString("muffin.httpProxyHost").length() > 0 && this.getInteger("muffin.httpProxyPort") > 0;
    }
}

